<?php

//namespace App\Models;


class campi_form {
	
	public $nome_campo = "";
	public $etichetta = "";
	public $tipo_campo = "";
	public $obbligatorio = false;
	public $min_len = null;
	public $max_len = null;
	public $classi_html = array();
	public $placeholder = "";
	public $opzioni_select = array();
	public $valore_fisso = null;
	public $parse_function = "";
	public $classi_etichetta = array();
	public $is_checked = null;
	public $classe_box = "";
	public $custom_html = "";


	public static $bottoni_form = array(
					"salva" => array("etichetta" => "<i class='fa fa-save'></i> Salva", "classi" => "btn-primary"),
					"annulla" => array("etichetta" => "<i class='fa fa-times'></i> Annulla", "classi" => "btn-danger"),
					"elenco" => array("etichetta" => "<i class='fa fa-list'></i> Torna all&apos;elenco", "classi" => "btn-warning", "link" => "#"),
				);


	public function __construct($nome, $tipo = "text", $obbligatorio = false, $classi_html = array(), $placeholder = "", $etichetta = "", $min_len = null, $max_len = null){
		
		$this->nome_campo = $nome;
		$this->etichetta = strlen($etichetta) > 0 ? $etichetta : ucwords(str_replace("_", " ", $nome));
		$this->tipo = $tipo;
		$this->obbligatorio = is_bool($obbligatorio) ? $obbligatorio : false;
		$this->min_len = is_int($min_len) ? $min_len : null;
		$this->max_len = is_int($max_len) ? $min_len : null;
		$this->classi_html = is_array($classi_html) ? $classi_html : array();
		$this->placeholder = $placeholder;
		
	}
	
	
	public function tipo_campo_form(){
		
		$tipo_campo_form = "";
		
		switch($this->tipo){
			
			case "text":
				$tipo_campo_form = "text";
				break;
			
			case "email":
				$tipo_campo_form = "email";
				break;
			
			case "password":
				$tipo_campo_form = "password";
				break;
			
			case "number":
				$tipo_campo_form = "number";
				break;
			
			case "select":
				$tipo_campo_form = "select";
				break;
			
			case "checkbox":
				$tipo_campo_form = "checkbox";
				break;
			
			case "radio":
				$tipo_campo_form = "radio";
				break;
			
			case "textarea":
				$tipo_campo_form = "textarea";
				break;
			
			case "hidden":
				$tipo_campo_form = "hidden";
				break;

			case "custom_macro":
				$tipo_campo_form = "custom_macro";
				break;
				
			case "parse_value":
				$tipo_campo_form = "parse_value";
				break;
			
			case "file":
				$tipo_campo_form = "file";
				break;
			
			case "solo_testo":
				$tipo_campo_form = "solo_testo";
				break;
			
			case "html":
				$tipo_campo_form = "html";
				break;
				
			
			default:
				$tipo_campo_form = "text";
				break;
		}
		
		return $tipo_campo_form;
	}
	
}