<?php

/**
 * Libreria con le funzioni standard "nostre", in modo che possano essere invocate direttamente senza passare da un metodo statico di qualche classe
 * 
 * alla lunga andranno a sostituire tutte le funzioni presenti in Strumenti\Librerie
 */


if (!function_exists("geocode")) {
	
	function geocode($address){

		// url encode the address
		$address = urlencode($address);

		// google map geocode api url
		//$url = "http://maps.google.com/maps/api/geocode/json?address={$address}";

		$url = "http://maps.google.com/maps/api/geocode/json?sensor=false&language=it&address={$address}";
		
		// get the json response
		$resp_json = file_get_contents($url);

		// decode the json
		$resp = json_decode($resp_json, true);

		// response status will be 'OK', if able to geocode given address 
		if($resp['status']=='OK'){

			// get the important data
			$lati = $resp['results'][0]['geometry']['location']['lat'];
			$longi = $resp['results'][0]['geometry']['location']['lng'];
			$formatted_address = $resp['results'][0]['formatted_address'];

			// verify if data is complete
			if($lati && $longi && $formatted_address){

				// put the data in the array
				$data_arr = array();            

				array_push(
					$data_arr, 
						$lati, 
						$longi, 
						$formatted_address
					);

				return $data_arr;

			}else{
				return false;
			}

		}else{
			return false;
		}
	}
}
	
	
	
if (!function_exists("debug_query")) {
	
	function debug_query($query_builder){
		
		if(get_class($query_builder) != "Illuminate\Database\Eloquent\Builder" && get_class($query_builder) != "Illuminate\Database\Query\Builder"){
			echo "<p>L'oggetto passato non e' del tipo corretto!"
					. "<p>Tipo atteso: <b>Illuminate\Database\Eloquent\Builder</b>"
					. "<br />Tipo ricevuto: <b>".get_class($query_builder)."</b>"
					. "<p>Puo' essere che sia stato invocato il metodo ->get() prima di passare la \"query\" al metodo di debug";
			die();
		}
		
		try{
			\DB::connection()->enableQueryLog();

			$query_builder->get();

			//echo "<pre>";
			$sql = \DB::getQueryLog()[0]["query"];
			$dati = \DB::getQueryLog()[0]["bindings"];

			if(isset($dati) && $dati != null && count($dati) > 0){

				if(strpos($sql, "?") !== false){

					//sostituiamo i ? in ordine
					foreach ($dati as $value){
						$sql = preg_replace("/\?/", "'".$value."'", $sql, 1);
					}				
				}else{
					foreach ($dati as $key => $value){
						$sql = str_replace(":".$key, "'".$value."'", $sql);
					}
				}

			}
			
			$sql = "<pre style='white-space: pre-wrap;'>".$sql."</pre>";
			\DB::connection()->disableQueryLog();
			\DB::connection()->flushQueryLog();
			
		}catch(\Exception $e){
			
			$sql = "<p>Siamo qui perch&eacute; la query presenta un errore e quindi non pu&ograve; essere esguito il binding automatico</p>";
			
			$sql .= "<p><b>Query:</b><pre style='white-space: pre-wrap;'>".$query_builder->toSql()."</pre>";
			
			$sql .= "<p><b>Bindings:</b> <pre style='white-space: pre-wrap;'>";
			$sql .= json_encode($query_builder->getBindings());
			$sql .= "</pre>";
			
			$sql .= "<p><b>Eccezione:</b> <pre style='white-space: pre-wrap;'>";
			$sql .= $e->getMessage();
			$sql .= "</pre>";
			
		}
		
		return $sql;
	}
}


if (!function_exists("stampa")) {

	/**
	 * questa funzione stampa (o ritorna) il valore passato come parametro.
	 * 
	 * se il sito lavora in multi-lingua, cerca se esiste la traduzione per la lingua corrente, altrimenti inserisce la parola nel db (in modo da poter essere tradotta in seguito)
	 * 
	 * 
	 * @global \App\Strumenti\classe_DB $conn
	 * @param type $testo
	 * @param type $really_print
	 * @return type
	 */
	function stampa($testo, $really_print = true, $js_available = false){

		$testo_tradotto = $testo;
		
		if(config("par.MULTILINGUA", false)){
			
			$lingua_sito = \Session::get("lingua_sito", "ENG"); //recuperiamo la lingua con cui l'utente desidera vedere il sito
			$lingua_default = config("par.DEFAULT_SITE_LANGUAGE"); //questa e' la lingua con cui sono stati scritti tutti i messaggi nel sito
			$colonna_default = "valore_".strtolower($lingua_default); //e questa e' la rispettiva colonna sul DB
			
			$nome_colonna = "valore_ita";

			switch ($lingua_sito) {
				case "ITA":
					$nome_colonna = "valore_ita";
					break;
				
				case "ENG":
					$nome_colonna = "valore_eng";
					break;

				default:
					$nome_colonna = "valore_ita";
					break;
			}
			
			//andiamo a vedere se c'e' gia' il record sul db
			if($lingua_sito != $lingua_default || config("par.FORCE_INSERT", false)){ //in questo modo andiamo a fare connessioni solo se non siamo nel contesto di default

				$result = App\Models\Traduzioni::where($colonna_default, $testo)->first();
				
				if($result === null){
					App\Models\Traduzioni::create([$colonna_default => $testo, "url_pagina" => \Request::fullUrl(), "js_available" => ($js_available ? 1 : 0)]);
				}else{
					$testo_tradotto = strlen($result->$nome_colonna) > 0 ? $result->$nome_colonna : $testo;
				}
			}
		}
		
		
		if($really_print){
			echo $testo_tradotto;
		}else{
			return $testo_tradotto;
		}
		
	}
	
}

if (!function_exists("js_translation")) {
	function js_translation(){
	
	$lingua_sito = \Session::get("lingua_sito", "ENG"); //recuperiamo la lingua con cui l'utente desidera vedere il sito
	$lingua_default = config("par.DEFAULT_SITE_LANGUAGE"); //questa e' la lingua con cui sono stati scritti tutti i messaggi nel sito
	$colonna_default = "valore_".strtolower($lingua_default); //e questa e' la rispettiva colonna sul DB

	$nome_colonna = "valore_ita";

	switch ($lingua_sito) {
		case "ITA":
			$nome_colonna = "valore_ita";
			break;

		case "ENG":
			$nome_colonna = "valore_eng";
			break;

		default:
			$nome_colonna = "valore_ita";
			break;
	}
	
	$arr = App\Models\Traduzioni::where("js_available", 1)->get();
	$result = array();
	
	foreach($arr as $value){
		$result[$value->$colonna_default] = stampa($value->$colonna_default, false);
	}
	
	
	return json_encode($result);
}
}

if (!function_exists("find_filter")) {
	/**
	 * verifica se e' presente il filtro passato come parametro
	 * 
	 * @param string $filtro nome filtro
	 * @return boolean esito
	 */
	function find_filter($filtro){

	$trovato = false;

	if(!function_exists("filter_list")){
		return false;
	}

	foreach (filter_list() as $value){
		if($value == $filtro){
			$trovato = true;
		}
	}

	return $trovato;
}
}


if (!function_exists("check_email")) {
/**
 * verifica la validita' di un indirizzo mail usando il FILTER_VALIDATE_EMAIL se presente o un'espressione regolare in caso contrario
 * 
 * @param string $mail indirizzo da verificare
 * @return boolean esito della verifica
 */
	function check_email($mail){

	$esito = false;

	if(strlen($mail) == 0){
		return false;
	}

	if(find_filter("validate_email")){

		if (filter_var($mail, FILTER_VALIDATE_EMAIL)===false){
			$esito = false;
		}else{
			$esito = true;
		}

	}else{

		if(strlen($mail) > 5){
			$pattern = '/^(?!(?:(?:\\x22?\\x5C[\\x00-\\x7E]\\x22?)|(?:\\x22?[^\\x5C\\x22]\\x22?)){255,})(?!(?:(?:\\x22?\\x5C[\\x00-\\x7E]\\x22?)|(?:\\x22?[^\\x5C\\x22]\\x22?)){65,}@)(?:(?:[\\x21\\x23-\\x27\\x2A\\x2B\\x2D\\x2F-\\x39\\x3D\\x3F\\x5E-\\x7E]+)|(?:\\x22(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x21\\x23-\\x5B\\x5D-\\x7F]|(?:\\x5C[\\x00-\\x7F]))*\\x22))(?:\\.(?:(?:[\\x21\\x23-\\x27\\x2A\\x2B\\x2D\\x2F-\\x39\\x3D\\x3F\\x5E-\\x7E]+)|(?:\\x22(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x21\\x23-\\x5B\\x5D-\\x7F]|(?:\\x5C[\\x00-\\x7F]))*\\x22)))*@(?:(?:(?!.*[^.]{64,})(?:(?:(?:xn--)?[a-z0-9]+(?:-+[a-z0-9]+)*\\.){1,126}){1,}(?:(?:[a-z][a-z0-9]*)|(?:(?:xn--)[a-z0-9]+))(?:-+[a-z0-9]+)*)|(?:\\[(?:(?:IPv6:(?:(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){7})|(?:(?!(?:.*[a-f0-9][:\\]]){7,})(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,5})?::(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,5})?)))|(?:(?:IPv6:(?:(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){5}:)|(?:(?!(?:.*[a-f0-9]:){5,})(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,3})?::(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,3}:)?)))?(?:(?:25[0-5])|(?:2[0-4][0-9])|(?:1[0-9]{2})|(?:[1-9]?[0-9]))(?:\\.(?:(?:25[0-5])|(?:2[0-4][0-9])|(?:1[0-9]{2})|(?:[1-9]?[0-9]))){3}))\\]))$/iD';

			if (preg_match($pattern, $mail) === 1) {
				$esito = true;
			}
		}
	}

	return $esito;
}
}


if (!function_exists("random_password")) {
/**
 * restituisce una stringa random (numeri e lettere maiuscole/minuscole) della lunghezza desiderata
 * 
 * @param int $length
 * @return string
 */
	function random_password($length = 10) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, strlen($characters) - 1)];
    }
    return $randomString;
}
}

if (!function_exists("log_last_page")) {
	function log_last_page(){

//	$last_page = \Request::path();
////	$last_page = "survey";
//	echo "<p>".$last_page."</p>";
//	var_dump(preg_match("/^survey\/[0-9]+$/", $last_page));
//	die();
	
	$pagina = \Request::path();
	$last_page = null;
	
	if($pagina == "survey" || $pagina == "raters"){
		$last_page = null;
		
	}elseif(preg_match("/^survey\/[0-9]+$/", $pagina) || preg_match("/^raters\/[0-9]+$/", $pagina)){
		$last_page = str_replace(\Request::root(), "", \Request::fullUrl());
	}
	
		
//	echo "<p>".$request->root();
//	echo "<p>".$request->decodedPath();
//	echo "<p>".$request->fullUrl();
//	
//	echo "<p>";
////	echo "<p>".\Request::url();
//	var_dump($request->query());
	
	
	\Auth::user()->ultima_pagina = $last_page;
	\Auth::user()->save();
	
}
}

if (!function_exists("put_session_tag")) {
	function put_session_tag($nome, $valore){
	
//	if(!is_array(\Session::get("session_tag", null))){
//		\Session::put("session_tag", array());
//	}
	
	$sess = \Session::get("session_tag.".$nome, null);
	if(isset($sess)){
		\Session::forget("session_tag.".$nome);
	}
	
	\Session::push("session_tag.".$nome, $valore);
	
}
}

if (!function_exists("get_session_tag")) {
	function get_session_tag($nome){
	$item = \Session::get("session_tag.".$nome, null);
	$out = null;
	
	if($item !== null && isset($item[0])){
		$out = $item[0];
	}
	return $out;
}
}

if (!function_exists("replace_question_tags")) {
	function replace_question_tags($testo){
	
		$out = $testo;

		foreach(App\Models\Domande::$available_tags as $tag){

			$out = str_replace("##".$tag."##", get_session_tag($tag), $out);

		}

		return $out;
	}
}

if (!function_exists("delete_constraints_sqlserver")) {
	/**
	 * Questa funzione cancella la constraint nel campo e nella tabella indicata
	 * @param string $nome_tabella
	 * @param string $nome_campo
	 */
	function delete_constraints_sqlserver($nome_tabella, $nome_campo){
		
		if(env('DB_CONNECTION', 'mysql') ==  'sqlsrv'){
		
			$arr = \DB::select("SELECT dc.Name AS nome
					FROM sys.tables t
					INNER JOIN sys.default_constraints dc ON t.object_id = dc.parent_object_id
					INNER JOIN sys.columns c ON dc.parent_object_id = c.object_id AND c.column_id = dc.parent_column_id
					WHERE t.Name = ? AND c.Name = ?
					ORDER BY t.Name", [$nome_tabella, $nome_campo]);

			foreach ($arr as $constraints){
				\DB::statement('ALTER TABLE '.$nome_tabella.' DROP CONSTRAINT '.$constraints->nome);
			}
		
		}
		
	}
	
}