<?php

//namespace JSM\Base;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;
use App\Strumenti\Librerie;
use App\Strumenti;

abstract class jsmModel extends Model{

	use ValidatingTrait;
	protected $rules = [];


	protected $validationMessages = [
		"numeric" => "Il campo &quot;:attribute&quot; deve essere numerico",
		"integer" => "Il campo &quot;:attribute&quot; deve contenere un numero intero",
		"date_nullable" => "Inserire una data valida (gg/mm/aaaa | aaaa-mm-gg) oppure lasciare vuoto il campo",
		"required" => " ",
	];

	
	public function __construct(array $attributes = []){
		
		//settiamo il formato della data se siamo su Linux e il DB e' SQL Server, altrimenti Carbon non riesce a costruire l'oggetto datetime correttamente
		if(config("database.default", "mysql") === "sqlsrv" && php_uname("s") === "Linux"){
			$this->dateFormat = 'Y-m-d H:i:s';
		}
		
		parent::__construct($attributes);
	}
	
	
	/**
	 * estendiamo il metodo base per fare in modo di processare gli input applicando le nostre conversioni prima di validare i dati
	 * 
	 * @param type $key
	 * @return type
	 */
	public function getAttributeValue($key){

		$val = parent::getAttributeValue($key);
		
		if(is_string($val)){
			self::parse_input_saving($this->getModel(), $key, $val);
		}
		
		return $val;
	}
	

	public static function boot(){
		parent::boot();

		static::creating(function($model){
			foreach($model->attributes as $key => $value){
				
				self::parse_input_saving($model, $key, $value);
//				$model->{$key} = empty($value) && $value !== 0 && $value !== 0.0 && $value !== "0" ? null : $value;
				$model->{$key} = $value;
			}
		});

		static::updating(function($model){
			
			foreach($model->attributes as $key => $value){
				
				self::parse_input_saving($model, $key, $value);
//				$model->{$key} = empty($value) && $value !== 0 && $value !== 0.0 && $value !== "0" ? null : $value;
				$model->{$key} = $value;
			}
		});
	}

	
	/**
	 * la funzione trasforma il dato ricevuto sulla base del tipo in modo che venga salvato correttamente su DB
	 * 
	 * @param type $model
	 * @param type $key
	 * @param type $value
	 */
	public static function parse_input_saving($model, $key, &$value){
		
		if(isset($model->types[$key]) && !empty($value)){
				
			$type = $model->types[$key];

			switch($type){
				
				case "float":
					
					if(strpos($value, ".") !== false && strpos($value, ",") !== false){
						
						$value = str_replace(".", "", $value);
						$value = str_replace(",", ".", $value);
						
					}elseif(strpos($value, ",") !== false){ //se c'e' solo la virgola, sostituiamola con il punto
						$value = str_replace(",", ".", $value);
					}

					break;
					
				case "valuta":
					
					if(strpos($value, ".") !== false && strpos($value, ",") !== false){
						
						$value = str_replace(".", "", $value);
						$value = str_replace(",", ".", $value);
						
					}elseif(strpos($value, ",") !== false){ //se c'e' solo la virgola, sostituiamola con il punto
						$value = str_replace(",", ".", $value);
						
					}elseif(strpos($value, ".") !== false){ //se c'e' solo il punto, ipotizziamo che la valuta abbia al massimo due cifre decimali
						
						$arr = explode(".", $value);
						
						if(strlen($arr[1]) === 3){ //dovrebbero essere le migliaia, quindi togliamo il punto
							$value = str_replace(".", "", $value);
						}
						
					}

					break;
				
				case "date":
					
					$value = classe_data::format_data($value);
					break;

				default:
					break;
			}
			
		}
		
		$value = (empty($value) && $value !== 0 && $value !== 0.0 && $value !== "0" ? null : $value);
	}
	

	public static function option_select($nome, $valore, $campo_ordine="", $allow_empty = true){
		
		$result = array();
		if($allow_empty){
			$result[""] = "--";
		}

		$table_name = with(new static)->getTable();

		if(strlen($campo_ordine) == 0 || !in_array($campo_ordine, \Schema::getColumnListing($table_name))){
			$campo_ordine = \Schema::getColumnListing($table_name)[0];
		}

//		foreach(self::orderBy($campo_ordine)->get() as $value){
//			$result[$value->$valore] = $value->$nome;
//		}
		
		$obj = self::orderBy($campo_ordine);
//		self::applica_permessi($obj);
		
		$nome_classe = get_called_class(); //in questo modo recuperiamo l'istanza della classe figlia
		$nome_classe::applica_permessi($obj);
		
		foreach($obj->get() as $value){
			$result[$value->$valore] = $value->$nome;
		}
		
		return $result;
	}
	
	
	public static function option_select_si_no($allow_empty = true){
		
		$result = array();
		if($allow_empty){
			$result[""] = "--";
		}
		
		$result[0] = 'No';
		$result[1] = 'S&igrave;';
		
		
		return $result;
	}
	
	
	
	public static function applica_permessi(&$builder_obj, $user_obj = null){
		/*
		 * questo metodo funge solo da placeholder, ogni modello che vuole implementare i permessi dovra' estendere questo metodo
		 */
	}

	
	public function stampa_data($nome_campo){
		return classe_data::stampa_data($this->$nome_campo);
	}
	
	public function stampa_dataTime($nome_campo){
		return classe_data::stampa_dataTime($this->$nome_campo);
	}
	
	public function stampa_valuta($nome_campo, $thousand = true, $euro = false){
		
		//se il campo passato fa parte di una relazione (es: getOggetto.nome), chiamiamo la funzione e quindi l'attributo
		if(strpos($nome_campo, ".") !== false){
			$rel = explode(".", $nome_campo)[0];
			$nome_campo = explode(".", $nome_campo)[1];
			
			$value = $this->$rel->$nome_campo;
		}else{
			$value = $this->$nome_campo;
		}
		$formatted = $value;
		if(is_numeric($value)){
			$formatted = number_format($value, "2", ",", ($thousand ? "." : ""));
			
			if($euro){
				$formatted .= " &euro;";
			}
		}
		
		return $formatted;
	}
	
	
	public function fillable_list(){
		return $this->fillable;
	}
	
}
