<?php

namespace JSM\Base\JSM;

use Illuminate\Support\Facades\View;
use Zofe\Rapyd\DataSet as DataSet;
use Zofe\Rapyd\Persistence;
use Illuminate\Support\Facades\Config;

use Zofe\Rapyd\Exceptions\DataSetException;



class totali_custom {
	
	public $colonna = "";
	public $etichetta = "";
	public $totale = "";
	public $type = "";


	public function __construct($colonna, $etichetta = "", $type = "valuta"){
		$this->colonna = $colonna;
		$this->etichetta = $etichetta;
		$this->type = $type;
	}
	
	
	public function get_totale(){
		
		$valore_formattato = $this->totale;
		
		switch($this->type){
			case "valuta":
				$valore_formattato = number_format($this->totale, "2", ",", ".")." &euro;";
				break;
			
			default :
				break;
		}
		
		return $valore_formattato;
	}
}






class jsmDataSet extends \Zofe\Rapyd\DataSet {
	
	protected $orderby_arr = array();
	public $totali_custom = array();
	protected $order_raw = false;

	public function orderBy($field, $direction = "asc", $raw = false){
		
		if ($raw===true){
			$this->order_raw = true;
		}
		
		$this->orderby_arr[$field] = $direction;
		
		return parent::orderBy($field, $direction);
	}


	public function build(){
		
		if(is_string($this->source) && strpos(" ", $this->source) === false){
			//tablename
			$this->type = "query";
			$this->query = $this->table($this->source);
		}elseif(is_a($this->source, "\Illuminate\Database\Eloquent\Model")){
			$this->type = "model";
			$this->query = $this->source;
			$this->key = $this->source->getKeyName();
		}elseif(is_a($this->source, "\Illuminate\Database\Eloquent\Builder")){
			$this->type = "model";
			$this->query = $this->source;
			$this->key = $this->source->getModel()->getKeyName();
		}elseif(is_a($this->source, "\Illuminate\Database\Query\Builder")){
			$this->type = "model";
			$this->query = $this->source;
		}elseif(is_a($this->source, "\Zofe\Rapyd\DataFilter\DataFilter")){
			
			$this->type = "model";
			$this->query = $this->source->query;

			if(is_a($this->query, "\Illuminate\Database\Eloquent\Model")){
				$this->key = $this->query->getKeyName();
			}elseif(is_a($this->query, "\Illuminate\Database\Eloquent\Builder")){
				$this->key = $this->query->getModel()->getKeyName();
			}
			
		}elseif(is_a($this->source, "\App\JSM\jsmDataFilter")){
			$this->type = "model";
			$this->query = $this->source->query;

			if(is_a($this->query, "\Illuminate\Database\Eloquent\Model")){
				$this->key = $this->query->getKeyName();
			}elseif(is_a($this->query, "\Illuminate\Database\Eloquent\Builder")){
				$this->key = $this->query->getModel()->getKeyName();
			}
		}
		//array
		elseif(is_array($this->source)){
			$this->type = "array";
		}else{
			throw new DataSetException(' "source" must be a table name, an eloquent model or an eloquent builder. you passed: '.get_class($this->source));
		}

		//build orderby urls
		$this->orderby_uri_asc = $this->url->remove('page'.$this->cid)->remove('reset'.$this->cid)->append('ord'.$this->cid, "-field-")->get().$this->hash;

		$this->orderby_uri_desc = $this->url->remove('page'.$this->cid)->remove('reset'.$this->cid)->append('ord'.$this->cid, "--field-")->get().$this->hash;

		//detect orderby
		$orderby = $this->url->value("ord".$this->cid);
		if($orderby){
			$this->orderby_field = ltrim($orderby, "-");
			$this->orderby_direction = ($orderby[0] === "-") ? "desc" : "asc";
			if($this->canOrderby($this->orderby_field)){
				$this->orderBy($this->orderby_field, $this->orderby_direction);
			}
		}

		//build subset of data
		switch($this->type){
			case "array":
				//orderby
				if(isset($this->orderby)){
					list($field, $direction) = $this->orderby;
					$column = array();
					foreach($this->source as $key => $row){
						$column[$key] = is_object($row) ? $row->{$field} : $row[$field];
					}
					if($direction == "asc"){
						array_multisort($column, SORT_ASC, $this->source);
					}else{
						array_multisort($column, SORT_DESC, $this->source);
					}
				}

				$limit = $this->limit ? $this->limit : 100000;
				$current_page = $this->url->value('page'.$this->cid, 0);
				$offset = (max($current_page - 1, 0)) * $limit;
				$this->data = array_slice($this->source, $offset, $limit);
				$this->total_rows = count($this->source);
				$this->paginator = new LengthAwarePaginator($this->data, $this->total_rows, $limit, $current_page, ['path' => Paginator::resolveCurrentPath(),
					'pageName' => "page".$this->cid,
				]);
				break;

			case "query":
			case "model":
				$this->total_rows = $this->query->count();
				
				foreach($this->totali_custom as $value_obj){
					$value_obj->totale = $this->query->sum($value_obj->colonna);
				}
				
				//orderby
//				if(isset($this->orderby)){
//					$this->query = $this->query->orderBy($this->orderby[0], $this->orderby[1]);
//				}
				
				foreach($this->orderby_arr as $key => $value){
					
					if ($this->order_raw){
						$this->query = $this->query->orderBy(\DB::Raw($key), $value);
					}else{
						$this->query = $this->query->orderBy($key, $value);
					}
//					$this->query = $this->query->orderBy(\DB::Raw("concat(right(left(codice,7),2),left(codice,4))"),"desc");
					
				}
				
				//limit-offset
				if(isset($this->limit)){

					$this->paginator = $this->query->paginate($this->limit, ['*'], 'page'.$this->cid);
					$this->data = $this->paginator;
				}else{
					$this->data = $this->query->get();
				}

				break;
		}
		return $this;
	}

}


//class jsmDataGrid extends \Zofe\Rapyd\DataGrid\DataGrid {
class jsmDataGrid extends jsmDataSet {
	

	public $show_result_number = true;
	public $tasti_azione_custom = array();


	public function add($name, $label = null, $orderby = false, $attributes = array()) {
		
        $column = new \Zofe\Rapyd\DataGrid\Column($name, $label, $orderby);
		$column->attributes($attributes);
		
        $this->columns[$column->name] = $column;
        if (!in_array($name,array("_edit"))) {
            $this->headers[] = $label;
        }
        if ($orderby) {
            $this->addOrderBy($column->orderby_field);
        }
        return $column;
    }
	
	
	public function build($view = '') {

        if ($this->output != '') return;
        ($view == '') and $view = 'layouts.jsmDataGrid';
        jsmDataSet::build();

        Persistence::save();

        foreach ($this->data as $tablerow) {

            $row = new \Zofe\Rapyd\DataGrid\Row($tablerow);

            foreach ($this->columns as $column) {

                $cell = new \Zofe\Rapyd\DataGrid\Cell($column->name);
				
				$cell->attributes($column->attributes);
                
				$sanitize = (count($column->filters) || $column->cell_callable) ? false : true;
                $value = $this->getCellValue($column, $tablerow, $sanitize);
                $cell->value($value);
                $cell->parseFilters($column->filters);
                if ($column->cell_callable) {
                    $callable = $column->cell_callable;
                    $cell->value($callable($cell->value, $tablerow));
                }
                $row->add($cell);
            }

            if (count($this->row_callable)) {
                foreach ($this->row_callable as $callable) {
                    $callable($row);
                }
            }
            $this->rows[] = $row;
        }
        $this->output = \View::make($view, array('dg' => $this, 'buttons'=>$this->button_container, 'label'=>$this->label))->render();
        return $this->output;
    }
	
	
	
	/*
	 * sezione standard, copiata diretta dalla classe che ora non estendiamo piu'
	 */
	
	protected $fields = array();
    /** @var Column[]  */
    public $columns = array();
    public $headers = array();
    public $rows = array();
    public $output = "";
    public $attributes = array("class" => "table");
    public $checkbox_form = false;
    
    protected $row_callable = array();

    /**
     * @param string $name
     * @param string $label
     * @param bool   $orderby
     *
     * @return Column
     */
//    public function add($name, $label = null, $orderby = false)
//    {
//        $column = new Column($name, $label, $orderby);
//        $this->columns[$column->name] = $column;
//        if (!in_array($name,array("_edit"))) {
//            $this->headers[] = $label;
//        }
//        if ($orderby) {
//            $this->addOrderBy($column->orderby_field);
//        }
//        return $column;
//    }

    //todo: like "field" for DataForm, should be nice to work with "cell" as instance and "row" as collection of cells
//    public function build($view = '')
//    {
//        if ($this->output != '') return;
//        ($view == '') and $view = 'rapyd::datagrid';
//        parent::build();
//
//        Persistence::save();
//
//        foreach ($this->data as $tablerow) {
//
//            $row = new Row($tablerow);
//
//            foreach ($this->columns as $column) {
//
//                $cell = new Cell($column->name);
//                $sanitize = (count($column->filters) || $column->cell_callable) ? false : true;
//                $value = $this->getCellValue($column, $tablerow, $sanitize);
//                $cell->value($value);
//                $cell->parseFilters($column->filters);
//                if ($column->cell_callable) {
//                    $callable = $column->cell_callable;
//                    $cell->value($callable($cell->value, $tablerow));
//                }
//                $row->add($cell);
//            }
//
//            if (count($this->row_callable)) {
//                foreach ($this->row_callable as $callable) {
//                    $callable($row);
//                }
//            }
//            $this->rows[] = $row;
//        }
//        $this->output = \View::make($view, array('dg' => $this, 'buttons'=>$this->button_container, 'label'=>$this->label))->render();
//        return $this->output;
//    }

    public function buildCSV($file = '', $timestamp = '', $sanitize = true,$del = array())
    {
        $this->limit = null;
        parent::build();

        $segments = \Request::segments();

        $filename = ($file != '') ? basename($file, '.csv') : end($segments);
        $filename = preg_replace('/[^0-9a-z\._-]/i', '',$filename);
        $filename .= ($timestamp != "") ? date($timestamp).".csv" : ".csv";

        $save = (bool) strpos($file,"/");

        //Delimiter
        $delimiter = array();
        $delimiter['delimiter'] = isset($del['delimiter']) ? $del['delimiter'] : ';';
        $delimiter['enclosure'] = isset($del['enclosure']) ? $del['enclosure'] : '"';
        $delimiter['line_ending'] = isset($del['line_ending']) ? $del['line_ending'] : "\n";

        if ($save) {
            $handle = fopen(public_path().'/'.dirname($file)."/".$filename, 'w');

        } else {

            $headers  = array(
                'Content-Type' => 'text/csv',
                'Pragma'=>'no-cache',
                '"Cache-Control' => 'must-revalidate, post-check=0, pre-check=0',
                'Content-Disposition' => 'attachment; filename="' . $filename.'"');

            $handle = fopen('php://output', 'w');
            ob_start();
        }

        fputs($handle, $delimiter['enclosure'].implode($delimiter['enclosure'].$delimiter['delimiter'].$delimiter['enclosure'], $this->headers) .$delimiter['enclosure'].$delimiter['line_ending']);

        foreach ($this->data as $tablerow) {
            $row = new Row($tablerow);

            foreach ($this->columns as $column) {

                if (in_array($column->name,array("_edit")))
                    continue;

                $cell = new Cell($column->name);
                $value =  str_replace('"', '""',str_replace(PHP_EOL, '', strip_tags($this->getCellValue($column, $tablerow, $sanitize))));

                // Excel for Mac is pretty stupid, and will break a cell containing \r, such as user input typed on a
                // old Mac.
                // On the other hand, PHP will not deal with the issue for use, see for instance:
                // http://stackoverflow.com/questions/12498337/php-preg-replace-replacing-line-break
                // We need to normalize \r and \r\n into \n, otherwise the CSV will break on Macs
                $value = preg_replace('/\r\n|\n\r|\n|\r/', "\n", $value);

                $cell->value($value);
                $row->add($cell);
            }

            if (count($this->row_callable)) {
                foreach ($this->row_callable as $callable) {
                    $callable($row);
                }
            }

            fputs($handle, $delimiter['enclosure'] . implode($delimiter['enclosure'].$delimiter['delimiter'].$delimiter['enclosure'], $row->toArray()) . $delimiter['enclosure'].$delimiter['line_ending']);
        }

        fclose($handle);
        if ($save) {
            //redirect, boolean or filename?
        } else {
            $output = ob_get_clean();

            return \Response::make(rtrim($output, "\n"), 200, $headers);
        }
    }

    protected function getCellValue($column, $tablerow, $sanitize = true)
    {
        //blade
        if (strpos($column->name, '{{') !== false || 
            strpos($column->name, '{!!') !== false) {

            if (is_object($tablerow) && method_exists($tablerow, "getAttributes")) {
                $fields = $tablerow->getAttributes();
                $relations = $tablerow->getRelations();
                $array = array_merge($fields, $relations) ;

                $array['row'] = $tablerow;

            } else {
                $array = (array) $tablerow;
            }

            $value = $this->parser->compileString($column->name, $array);

        //eager loading smart syntax  relation.field
        } elseif (preg_match('#^[a-z0-9_-]+(?:\.[a-z0-9_-]+)+$#i',$column->name, $matches) && is_object($tablerow) ) {
            //switch to blade and god bless eloquent
            $_relation = '$'.trim(str_replace('.','->', $column->name));
            $expression = '{{ isset('. $_relation .') ? ' . $_relation . ' : "" }}';
            $fields = $tablerow->getAttributes();
            $relations = $tablerow->getRelations();
            $array = array_merge($fields, $relations) ;
            $value = $this->parser->compileString($expression, $array);

        //fieldname in a collection
        } elseif (is_object($tablerow)) {

            $value = @$tablerow->{$column->name};
            if ($sanitize) {
                $value = $this->sanitize($value);
            }
        //fieldname in an array
        } elseif (is_array($tablerow) && isset($tablerow[$column->name])) {

            $value = $tablerow[$column->name];

        //none found, cell will have the column name
        } else {
            $value = $column->name;
        }

        //decorators, should be moved in another method
        if ($column->link) {
            if (is_object($tablerow) && method_exists($tablerow, "getAttributes")) {
                $array = $tablerow->getAttributes();
                $array['row'] = $tablerow;
            } else {
                $array = (array) $tablerow;
            }
            $value =  '<a href="'.$this->parser->compileString($column->link, $array).'">'.$value.'</a>';
        }
        if (count($column->actions)>0) {
            $key = ($column->key != '') ?  $column->key : $this->key;
            $keyvalue = @$tablerow->{$key};

            $value = \View::make('rapyd::datagrid.actions', array('uri' => $column->uri, 'id' => $keyvalue, 'actions' => $column->actions));

        }

        return $value;
    }

    public function getGrid($view = '')
    {
        $this->build($view);

        return $this->output;
    }

    public function __toString()
    {
        if ($this->output == "") {

           //to avoid the error "toString() must not throw an exception"
           //http://stackoverflow.com/questions/2429642/why-its-impossible-to-throw-exception-from-tostring/27307132#27307132
           try {
               $this->getGrid();
           }
           catch (\Exception $e) {
               $previousHandler = set_exception_handler(function (){ });
               restore_error_handler();
               call_user_func($previousHandler, $e);
               die;
           }

        }

        return $this->output;
    }

    public function edit($uri, $label='Edit', $actions='show|modify|delete', $key = '')
    {
        return $this->add('_edit', $label)->actions($uri, explode('|', $actions))->key($key);
    }

    public function getColumn($column_name)
    {
        if (isset($this->columns[$column_name])) {
            return $this->columns[$column_name];
        }
    }

    public function addActions($uri, $label='Edit', $actions='show|modify|delete', $key = '')
    {
        return $this->edit($uri, $label, $actions, $key);
    }

    public function row(\Closure $callable)
    {
        $this->row_callable[] = $callable;

        return $this;
    }

    protected function sanitize($string)
    {
        $result = nl2br(htmlspecialchars($string));
        return Config::get('rapyd.sanitize.num_characters') > 0 ? str_limit($result, Config::get('rapyd.sanitize.num_characters')) : $result;
    }
	
}
