<?php

namespace JSM\Base;

use Illuminate\Support\ServiceProvider;

class jsmServiceProvider extends ServiceProvider{

	/**
	 * Bootstrap the application services.
	 *
	 * @return void
	 */
	public function boot(){

//        $this->publishes([
//			__DIR__.'/JSM' => base_path('app/JSM'),
//		], "jsm");

		$this->publishes([
			__DIR__.'/Mail' => base_path('app/Mail'),
				], "mail");

		$this->publishes([
			__DIR__.'/views' => base_path('resources/views'),
				], "views");

		$this->publishes([
			__DIR__.'/Policies' => base_path('app/Policies'),
				], "policies");


//		$this->loadRoutesFrom(__DIR__.'/routes.php');


		\Route::group([
			'middleware' => 'web',
				//'namespace' => $this->namespace,
				], function ($router){
			require __DIR__.'/routes.php';
		});

		$this->app->make('JSM\Base\Controllers\jsmController');
		$this->app->make('JSM\Base\Controllers\ExampleController');
	}

	/**
	 * Register the application services.
	 *
	 * @return void
	 */
	public function register(){
//		include __DIR__.'/routes.php';
//		$this->app->make('JSM\Base\Controllers\jsmController');
		$this->app->make('JSM\Base\Controllers\MainController');
//		$this->app->make('JSM\Base\Controllers\ExampleController');
		
		try{
			$this->app['router']->aliasMiddleware('isAdmin', 'JSM\Base\Middleware\isAdmin');
			$this->app['router']->aliasMiddleware('checkGate', 'JSM\Base\Middleware\checkGate');
		}catch(\BadMethodCallException $e){
			$this->app['router']->middleware('isAdmin', 'JSM\Base\Middleware\isAdmin');
			$this->app['router']->middleware('checkGate', 'JSM\Base\Middleware\checkGate');
		}catch(\Exception $e){
			die("jsmServiceProvider: middleware method not found!");
		}
	}

}
