<?php

namespace JSM\Base;

use Illuminate\Mail\Transport\Transport;
use Illuminate\Support\Facades\Log;
use Swift_Mime_Message;

class PostmanTransport extends Transport{

	
	public function __construct(){
		
	}

	
	public function send(Swift_Mime_Message $message, &$failedRecipients = null){
		
		if(count($message->getFrom()) > 0){
			$sender = $message->getFrom()[array_keys($message->getFrom())[0]]." <".array_keys($message->getFrom())[0].">";
		}else{
			$sender = "";
		}
		
		
		$esito = false;
		
		$json_message = array(
			// Source is required
			'Source' => $sender,
			// Destination is required
			'Destination' => array(
				'ToAddresses' => array_keys($message->getTo()),
				'BccAddresses' => array()
			),
			// Message is required
			'Message' => array(
				// Subject is required
				'Subject' => array(
					// Data is required
					'Data' => $message->getSubject(),
					'Charset' => 'UTF-8',
				),
				// Body is required
				'Body' => array(
					'Text' => array(
						// Data is required
						'Data' => "",
						'Charset' => 'UTF-8',
					),
					'Html' => array(
						// Data is required
						'Data' => $message->getBody(),
						'Charset' => 'UTF-8',
					),
				),
			)
		);

		try{
			$cipher = new AESCipher(env("POSTMAN_API_KEY"));
			$messaggio = $cipher->encrypt(json_encode($json_message));

			$url = env("MAIL_HOST", 'http://postman.sinergo.it');

			$eol = "\r\n";
			$data = '';
			$mime_boundary=md5(time());
			//
			$data .= '--' . $mime_boundary . $eol;
			$data .= 'Content-Disposition: form-data; name="id"' . $eol . $eol;
			$data .= env("POSTMAN_ID") . $eol;
			$data .= '--' . $mime_boundary . $eol;
			$data .= 'Content-Disposition: form-data; name="info"' . $eol . $eol;
			$data .= $messaggio . $eol;
			$data .= '--' . $mime_boundary . $eol;
			$data .= "--" . $mime_boundary . "--" . $eol . $eol;

			// use key 'http' even if you send the request to https://...
			$options = array(
				'http' => array(
					'header'  => "Content-type: multipart/form-data; boundary=" . $mime_boundary,
					'method'  => 'POST',
					'content' => $data
				)
			);

			$context  = stream_context_create($options);
			$result = file_get_contents($url, FILE_TEXT, $context);
			$result = json_decode($result,true);
		}catch(Exception $e){
			$result = false;
		}

		if(!$result){
			$esito = false;
		}else{
			if(array_key_exists("status",$result)){
				if($result['status']=="OK"){
					$esito = true;
				}
			}
		}
		
//		echo "<pre>";
//		var_dump($result);
//		echo "</pre>";
		
		return $esito;
		
	}

}
