<?php

namespace JSM\Base\Controllers;

use \App\Http\Controllers;
use Collective\Html\FormFacade as Form;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Session;
//use App\Models\campi_form;
//use App\Strumenti\Librerie;
//use App\Strumenti;
use Validator;
use Auth;
use Illuminate\Database\Eloquent\ModelNotFoundException;
//use App\Custom;

class jsmController extends Controller{
	
	protected $bottoni_form = array();
	protected $campi = array();
	protected $url_base = "";
	protected $url_base_param = "";


	protected $friendly_name = "";
	protected $new_title = "";
	protected $edit_title = "";
	protected $elenco_title = "";
	protected $create_messagge = "";
	protected $edit_messagge = "";
	protected $delete_messagge = "";
	protected $not_found_messagge = "";
	protected $titolo_pagina_generico = "";

	protected $custom_view_param = array();

	
	/**
	 *
	 * @var \Illuminate\Database\Eloquent\Model 
	 */
	protected $model_name = "";
	protected $existing_obj = null;
	
	
	
	public function __construct(){
		/* -------------------------------------------------------------------
		 * impostazioni generali usate in tutto il controller
		 */

		
		$this->init_param_info();

		$this->bottoni_form = \campi_form::$bottoni_form; /* recuperiamo i bottoni base per il form di edit e andiamo a modificare i campi necessari */

		/* andiamo a sovrascrivere, eventualmente, il comportamento base dei bottoni */
		$this->bottoni_form["elenco"]["link"] = $this->url_base;
		//$this->bottoni_form["salva"]["etichetta"] = "<i class='fa fa-pencil'></i> Salva";

		/*
		 * ------------------------------------------------------------------- */
	}
	
	
	/**
	 * permette di aggiungere all'array custom_view_param una coppia chiave => valore <br>
	 * che i vari metodi passeranno alle viste in aggiunta ai parametri info standard
	 * 
	 * @param string $nome
	 * @param string $valore
	 */
	public function add_view_param($nome, $valore){
		$this->custom_view_param[$nome] = $valore;
	}
	
	
	/**
	 * re-inizializza i nomi dei vari attributi, in modo da poterli richiamare nei vari metodi e avere accesso alla sessione
	 * 
	 * ATTENZIONE! Va ridefinito nei vari controller in modo da sostituire correttamente le informazioni
	 */
	public function init_param_info(){
		
		$model_guess_name = str_replace("Controller", "", basename(str_replace("\\", "/", get_class($this)))); //quest non va ripetuto nel controller esteso
		
		$this->url_base = url("/path");   /* definiamo il percorso base di tutti gli url presenti nella pagina */
		$this->model_name = "App\Models\\".$model_guess_name; /* definiamo il nome completo del modello da usare in tutti i metodi (quantomeno quelli base) */
		
		$this->friendly_name = stampa("Name", false);
		$this->elenco_title = stampa("Name list", false);
		$this->new_title = stampa("New ".$this->friendly_name, false);
		$this->edit_title = stampa("Edit ".$this->friendly_name, false);
		$this->create_messagge = stampa($this->friendly_name." created", false);
		$this->edit_messagge = stampa($this->friendly_name." updated", false);
		$this->delete_messagge = stampa($this->friendly_name." deleted", false);
		$this->not_found_messagge = stampa($this->friendly_name." not found", false);
		$this->titolo_pagina_generico = stampa('Name', false);
	}
	
	
	/**
	 * definisce quali sono i campi da mostrare nei form di insert / edit, da chiamare negli opportuni metodi<br />
	 * in questo modo possiamo accedere anche alle informazioni di sessione (ad esempio gli utenti loggati!)
	 * 
	 */
	public function init_form_fields(){
		/*
		 * creiamo l'array con i campi da passare al visualizzatore di form (insert/edit)
		 */		
		
		
	}
	
	
	
	/**
	 * Display a listing of the resource.
	 * GET /[route]
	 *
	 * @return Response
	 */
	public function index(){
		
		$model_name = $this->model_name;
		
		/*
		 * controllo permessi
		 */
		if (\Auth::user() === null || \Auth::user()->cant('access', $this->model_name)) {
			return view("errors.error_page", $this->custom_view_param);
		}
		
		$obj = new $model_name;
		$query = $model_name::getQuery();
		
		$model_name::applica_permessi($query);
		
		$grid = \jsmDataGrid::source($query);
		
		foreach(array_slice($obj->getModel()->fillable_list(), 0, 10) as $key){
			$grid->add($key, $key);
		}
		
		$grid->paginate(50);
		
		$info = compact('grid');
		$info["titolo"] = $this->elenco_title."&nbsp;&nbsp;&nbsp;&nbsp;<span style='font-size: 16px; font-style: italic;'>[i primi 10 campi raccolti automaticamente]</span>";
		$info["bottone_new"] = "<i class='fa fa-plus'></i>&nbsp;&nbsp;".$this->new_title;
		$info["url_create"] = $this->url_base."/create";
		$info["classe_box"] = "box-primary";
		

		return view('moduli.pagina_elenco', array_merge(array("info" => $info), $this->custom_view_param));
	}
	
	
	/**
	 * Show the form for creating a new resource.
	 * GET /[route]/create
	 *
	 * @return Response
	 */
	public function create(Request $request, $landing_view = ""){
		
		/*
		 * controllo permessi
		 */
		if (\Auth::user() === null || \Auth::user()->cant('create', $this->model_name)) {
			return view("errors.error_page", $this->custom_view_param);
		}
		
		
		
		
		$model_name = $this->model_name;
		$this->existing_obj = $existing_obj = new $model_name();
		
		$this->init_form_fields();
		
		$info = array(
			"title" => $this->new_title,
			"titolo_pagina" => $this->titolo_pagina_generico,
			"main_title" => true,
			"url" => "/".basename($this->url_base),
			"campi" => $this->campi,
			//"campi_avanzati" => $this->campi2,
			"bottoni_form" => $this->bottoni_form,
			"obj" => compact('existing_obj'),
		);

		return view((strlen($landing_view) > 0 ? $landing_view : "moduli.edit_form"), array_merge($info, $this->custom_view_param));
	}

	
	/**
	 * Store a newly created resource in storage.
	 * POST /[route]
	 *
	 * @param Request $request
	 * @return Response
	 */
	public function store(Request $request, $landing_page = ""){
		
		/*
		 * controllo permessi
		 */
		if (\Auth::user() === null || \Auth::user()->cant('create', $this->model_name)) {
			return view("errors.error_page", $this->custom_view_param);
		}


		$model_name = $this->model_name;
		$requestData = $request->all();

		$this->existing_obj = $existing_obj = $model_name::create($requestData);
		
		Session::flash("existing_obj", $existing_obj);

		if($existing_obj->isInvalid()){
			Session::flash("error_saving", true);
//			Session::flash("existing_obj", $existing_obj);
			return redirect($this->url_base.'/create'.$this->url_base_param)
							->withErrors($existing_obj->getErrors())
							->withInput();
		}

		$existing_obj->save();

		Session::flash('flash_message', '<div class="alert alert-success data_saved auto_close">'.$this->create_messagge.stampa(' successfully', FALSE).'!</div>');

		if(strlen($landing_page) > 0){
			$landing_page = str_replace("{item_id}", $existing_obj->getKey(), $landing_page);
		}
		
		Session::flash('new_created_item_id', $existing_obj->getKey());
		return redirect((strlen($landing_page) > 0 ? $landing_page : $this->url_base));
	}

	
	
	/**
	 * Display the specified resource.
	 * GET /[route]/{id}
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function show($id, Request $request){
		
		$model_name = $this->model_name;
		try{
			$this->existing_obj = $existing_obj = $model_name::findOrFail($id);
		}catch(\Exception $e){
			return view("errors.error_page", array_merge(["messaggio" => stampa("Item not found!", false)], $this->custom_view_param));
		}
		
		/*
		 * controllo permessi
		 */
		if (\Auth::user() === null || \Auth::user()->cant('view', $existing_obj)) {
			return view("errors.error_page", $this->custom_view_param);
		}
		
		return $this->edit($id);
	}

	
	/**
	 * Show the form for editing the specified resource.
	 * GET /[route]/{id}/edit
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function edit($id, $landing_view = ""){
		
		
		
		$model_name = $this->model_name;
		try{
			$this->existing_obj = $existing_obj = $model_name::findOrFail($id);
		}catch(\Exception $e){
			return view("errors.error_page", array_merge(["messaggio" => stampa("Item not found!", false)], $this->custom_view_param));
		}
		
		/*
		 * controllo permessi
		 */
		if (\Auth::user() === null || \Auth::user()->cant('update', $existing_obj)) {
			return view("errors.error_page", $this->custom_view_param);
		}
		

		$this->init_form_fields();
		Session::flash("existing_obj", $existing_obj);
		
		$info = array(
			"title" => $this->edit_title,
			"titolo_pagina" => $this->titolo_pagina_generico,
			"main_title" => true,
			"url" => "/".basename($this->url_base),
			"campi" => $this->campi,
			//"campi_avanzati" => $this->campi2,
			"bottoni_form" => $this->bottoni_form,
			"obj" => compact('existing_obj')
			
		);

		return view((strlen($landing_view) > 0 ? $landing_view : "moduli.edit_form"), array_merge($info, $this->custom_view_param));
	}

	
	
	/**
	 * Update the specified resource in storage.
	 * PUT /[route]/{id}
	 *
	 * @param int $id
	 * @param Request $request
	 * @return Response
	 */
	public function update($id, Request $request, $landing_page = ""){

		Session::flash("error_saving", true);
		$model_name = $this->model_name;

		$requestData = $request->input();
		
		try{
			$this->existing_obj = $existing_obj = $model_name::findOrFail($id);
		}catch(\Exception $e){
			return view("errors.error_page", array_merge(["messaggio" => stampa("Item not found!", false)], $this->custom_view_param));
		}
		
		/*
		 * controllo permessi
		 */
		if (\Auth::user() === null || \Auth::user()->cant('update', $existing_obj)) {
			return view("errors.error_page", $this->custom_view_param);
		}
		
		Session::flash("existing_obj", $existing_obj);
		//die('qui');
		if(!$existing_obj->update($requestData)){
			
//			var_dump($existing_obj->getErrors());
//			die();
			Session::flash("error_saving", true);
			
			return redirect($this->url_base.'/'.$id.'/edit'.$this->url_base_param)
							->withErrors($existing_obj->getErrors())
							->withInput();
		}
		else {
			Session::flash("error_saving", false);
		}

		
		Session::flash('flash_message', '<div class="alert alert-success data_saved auto_close">'.$this->edit_messagge.stampa(' successfully', FALSE).'!</div>');

		return redirect((strlen($landing_page) > 0 ? $landing_page : $this->url_base.$this->url_base_param));
		
	}
	
	

	/**
	 * Remove the specified resource from storage.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
	 */
	public function destroy($id, $landing_page = ""){
		$model_name = $this->model_name;
		
		try{
			$this->existing_obj = $existing_obj = $model_name::findOrFail($id);
		}catch(\Exception $e){
			return view("errors.error_page", array_merge(["messaggio" => stampa("Item not found!", false)], $this->custom_view_param));
		}
		
		/*
		 * controllo permessi
		 */
		if (\Auth::user() === null || \Auth::user()->cant('delete', $existing_obj)) {
			return view("errors.error_page", $this->custom_view_param);
		}
				
		$model_name::destroy($id);

		Session::flash('flash_message', '<div class="alert alert-success data_saved auto_close">'.$this->delete_messagge.stampa(' successfully', FALSE).'!</div>');
		
		return redirect((strlen($landing_page) > 0 ? $landing_page : $this->url_base));
		
	}
	
}
