<?php

//namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Log;

/**
 * Class JsmLog
 */
class jsmLog extends Model
{
    protected $table = 'jsm_log';

    public $timestamps = true;

    protected $fillable = [
        'nome_azione',
        'tipo_azione',
        'url',
        'utente',
        'ip',
        'info',
        'inviare',
        'old_data'
    ];

    protected $guarded = [];

	/*
	 * Per queste classi non vengono effettuati i log (altrimenti andiamo in loop)
	 */
	public static $excluded_class = ["LogJsm", "jsmLog"];

	
	/**
	 * Se i log sono abilitati, salva un record nel DB, eventualmente salvando anche i dati precedenti alla modifica
	 * 
	 * @param string $nome_azione
	 * @param string $tipo_azione
	 * @param mixed $info NULL | array | string informazioni aggiuntive
	 * @param mixed $current_obj NULL | oggetto corrente
	 */
	public static function log_event($nome_azione, $tipo_azione, $info=null, $current_obj=null){
		
		if(config("jsm_log.log_enabled", false) === false){
			return;
		}
		
		$old_data = null;
		
		if(config("jsm_log.log_save_old_data", false) === true && is_object($current_obj)){
			try{
				$old_data = json_encode($current_obj->getOriginal());
			} catch (\Exception $ex) {
				Log::error("Errore estrazione old_data: ".$ex->getMessage());
				
				if(config('app.debug')){
					throw $ex;
				}
			}
		}
		
		try{
			$url = \Request::fullUrl();
			$ip = \Request::ip();

			$id_utente = \Auth::user() !== null ? \Auth::user()->getKey() : null;

			if(is_array($info)){
				$info = json_encode($info);
			}

			self::create([
				'nome_azione' => $nome_azione,
				'tipo_azione' => $tipo_azione,
				'url' => $url,
				'utente' => $id_utente,
				'ip' => $ip,
				'info' => $info,
				'old_data' => $old_data,
			]);
			
		} catch (\Exception $ex) {
			Log::error("Errore salvataggio log: ".$ex->getMessage());
			
			if(config('app.debug')){
				throw $ex;
			}
		}
	}
	
}