<?php

namespace JSM\Base\Controllers;

use Illuminate\Http\Request;

class ExampleController extends jsmController
{
    
	public function __construct(){
		/* -------------------------------------------------------------------
		 * impostazioni generali usate in tutto il controller
		 */

//		$this->middleware('auth');
		
		$this->init_param_info();

		$this->bottoni_form = \campi_form::$bottoni_form; /* recuperiamo i bottoni base per il form di edit e andiamo a modificare i campi necessari */

		/* andiamo a sovrascrivere, eventualmente, il comportamento base dei bottoni */
		$this->bottoni_form["elenco"]["link"] = $this->url_base;
		//$this->bottoni_form["salva"]["etichetta"] = "<i class='fa fa-pencil'></i> Salva";

		/*
		 * ------------------------------------------------------------------- */
	}
	
	
	/**
	 * re-inizializza i nomi dei vari attributi, in modo da poterli richiamare nei vari metodi e avere accesso alla sessione
	 */
	public function init_param_info(){
		
		$this->url_base = url("/example");   /* definiamo il percorso base di tutti gli url presenti nella pagina */
		$this->model_name = "App\Models\Utenti"; /* definiamo il nome completo del modello da usare in tutti i metodi (quantomeno quelli base) */
		
		$this->friendly_name = stampa("User", false);
		$this->elenco_title = stampa("User list", false);
		$this->new_title = stampa("New ".$this->friendly_name, false);
		$this->edit_title = stampa("Edit ".$this->friendly_name, false);
		$this->create_messagge = stampa($this->friendly_name." created", false);
		$this->edit_messagge = stampa($this->friendly_name." updated", false);
		$this->delete_messagge = stampa($this->friendly_name." deleted", false);
		$this->not_found_messagge = stampa($this->friendly_name." not found", false);
		$this->titolo_pagina_generico = stampa('Users', false);
	}
	
	
	/**
	 * definisce quali sono i campi da mostrare nei form di insert / edit, da chiamare negli opportuni metodi<br />
	 * in questo modo possiamo accedere anche alle informazioni di sessione (ad esempio gli utenti loggati!)
	 * 
	 */
	public function init_form_fields($insert = true){
		/*
		 * creiamo l'array con i campi da passare al visualizzatore di form (insert/edit)
		 */		
		
		$this->campi[] = new \campi_form("nome", "text", TRUE, array('nome'),"",stampa("Nome", false));
		$this->campi[] = new \campi_form("cognome", "text", TRUE, array('cognome'),"",stampa("Cognome", false));
		
		if($insert){
			$this->campi[] = new \campi_form("email", "email", TRUE, array('email'),"",stampa("Email", false));
		}
		
		$this->campi[] = new \campi_form("password", "password", TRUE, array('password'),"",stampa("Password", false));
		
		$campo_sesso = new \campi_form("sesso", "select", TRUE, array('sesso'),"",stampa("Sesso", false));
		$campo_sesso->opzioni_select = array("M" => "M", "F" => "F");
		$this->campi[] = $campo_sesso;
			
	}
	
	
	public function init_filter_list(Request $request, $obj = null){
		
		$filter = \jsmDataFilter::source($obj);
		
		$filter->gruppi_filtri["gp_1"] = array("class" => "col-lg-3", "label_style" => "");
//		$filter->gruppi_filtri["gp_2"] = array("class" => "col-lg-4", "label_style" => "");
//		$filter->gruppi_filtri["gp_3"] = array("class" => "col-lg-3", "label_style" => "");
		$filter->gruppi_filtri["zdefault"] = array("class" => "col-lg-9 text-right", "label_style" => "");
		
		
				
		$filter->add("sesso", "Sesso", "select")->attributes(["class" => "auto_submit", "gruppo" => "gp_1", "label_width" => "85px"])->options(["M" => "Male", "F" => "Female"]);
		
		$filter->text('ragione_sociale', 'Nome e Cognome')->attributes(["show_label" => false])->scope('freeSearch');		
		
		
		$filter->add("1", "search", "container")
				->attributes(["show_label" => false])
				->content('<button class="btn btn-default" type="submit">
								<i class="fa fa-search"></i>
							</button>');
		$filter->add("2", "reset", "container")
				->attributes(["show_label" => false])
				->content('<a title="Resetta filtri" class="btn btn-default" href="'.$this->bottoni_form["elenco"]["link"].'">
								<i class="fa fa-times"></i>
							</a>');
		
		return $filter;
	}
	
	
	/**
	 * Display a listing of the resource.
	 * GET /[resource]
	 *
	 * @return Response
	 */
	public function index(Request $request = null){

		$model_name = $this->model_name;
		//$obj = $model_name::with("getNomeRelazione");
		
		$tmp = new $model_name();
		$query_obj = $tmp->newQuery();
//		
//		$model_name::applica_permessi($query_obj);
		
//		echo debug_query($query_obj);
//		die();
		
		
		

		$filter = $this->init_filter_list($request, $query_obj);
		$grid = \jsmDataGrid::source($query_obj);  //same source types of DataSet
		
		
//		echo "<p>".get_class($obj);
//		echo "<p>".get_class($query_obj);
//		echo "<p>".get_class($filter);
//		die();
		
//		$grid_no_page = clone $grid;
		

		
		//$grid = jsmDataGrid::source(new Anagrafica);  //same source types of DataSet
		$grid->add('cognome', 'Cognome', true)->cell(function ($value, $row){
			return '<a href="'.$this->url_base.'/'.$row->getKey().'">'.$value.'</a>';
		});
		
		$grid->add('nome', 'Nome', true);
		$grid->add('email', 'E-mail');
		
		$grid->add("sesso", "sesso", false, ["class" => "hidden-xs hidden-md hidden-sm"]);
		
		
				
		$grid->add('edit', 'Actions')->cell(function ($value, $row){
			
			//mostriamo i tasti edit solo se abbiamo i permessi di update (andrebbero diversificati tra edit e delete)
			if (\Auth::user() !== null && \Auth::user()->can('update', $row)) {
				return view("moduli.btn_actions", array(
					"id" => $row->id,
					"url" => $this->url_base,
					"parametri_edit" => "?view=full",
					"nome" => $row->ragione_sociale
				));
			}
		});
		
//		$filter->build();
//		$grid->build();
//		echo debug_query($grid->query);

		$querystring = $_SERVER["QUERY_STRING"];
		
		$grid->orderBy('cognome', 'asc'); //default orderby
		$grid->paginate(30); //pagination
		
		
		$info = compact('filter', 'grid');
		$info["titolo"] = $this->elenco_title;
		$info["main_title"] = true;
		$info["bottone_new"] = $this->new_title;
		$info["url_create"] = $this->url_base."/create?view=full";
		$info["classe_box"] = "box-primary";
		$info["tasti_custom_top"] = array(
				"<a href='".url("/excel/elenco_clienti?".$querystring)."' title='Esporta risultati in Excel' class='btn btn-primary pull-right' target='_blank'>
					<i class='fa fa-file-excel-o'></i> Excel
				</a>"
			);
		
		
		return view('moduli.pagina_elenco', array(
								"info" => $info,
//								"arr_val_job" => $arr_val_job,
//								"proiezione" => $proiezione_perc,
//								"massimo_importo" => $massimo_importo,
//								"massimo_numero" => $massimo_numero,
//								"sedi" => json_encode($coordinate_sedi),
					));
	}
	
}
