<?php



class campi_form {
	
	public $nome_campo = "";
	public $etichetta = "";
	public $tipo_campo = "";
	public $obbligatorio = false;
	public $min_len = null;
	public $max_len = null;
	public $classi_html = array();
	public $placeholder = "";
	public $opzioni_select = array();
	public $valore_fisso = null;
	public $parse_function = "";
	public $parse_options = array();
	public $classi_etichetta = array();
	public $is_checked = null;
	public $classe_box = "";
	public $custom_html = "";
	public $attributes = array();


	public static $bottoni_form = array(
					"salva" => array("etichetta" => "<i class='fa fa-save'></i> Salva", "classi" => "btn-primary edit_form_field"),
					"annulla" => array("etichetta" => "<i class='fa fa-times'></i> Annulla", "classi" => "btn-danger edit_form_field"),
					"modifica" => array("etichetta" => "<i class='fa fa-pencil'></i> Modifica", "classi" => "btn-info edit_form_js view_form_field"),
					"elenco" => array("etichetta" => "<i class='fa fa-list'></i> Torna all&apos;elenco", "classi" => "btn-warning", "link" => "#"),
				);


	public function __construct($nome, $tipo = "text", $obbligatorio = false, $classi_html = array(), $placeholder = "", $etichetta = "", $min_len = null, $max_len = null){
		
		$this->nome_campo = $nome;
		$this->etichetta = strlen($etichetta) > 0 ? $etichetta : ucwords(str_replace("_", " ", $nome));
		$this->tipo = $tipo;
		$this->obbligatorio = is_bool($obbligatorio) ? $obbligatorio : false;
		$this->min_len = is_int($min_len) ? $min_len : null;
		$this->max_len = is_int($max_len) ? $min_len : null;
		$this->classi_html = is_array($classi_html) ? $classi_html : array();
		$this->placeholder = $placeholder;
		
	}
	
	
	public function tipo_campo_form(){
		
		$tipo_campo_form = "";
		
		switch($this->tipo){
			
			case "text":
				$tipo_campo_form = "text";
				break;
			
			case "email":
				$tipo_campo_form = "email";
				break;
			
			case "password":
				$tipo_campo_form = "password";
				break;
			
			case "number":
				$tipo_campo_form = "number";
				break;
			
			case "select":
				$tipo_campo_form = "select";
				break;
			
			case "checkbox":
				$tipo_campo_form = "checkbox";
				break;
			
			case "radio":
				$tipo_campo_form = "radio";
				break;
			
			case "textarea":
				$tipo_campo_form = "textarea";
				break;
			
			case "hidden":
				$tipo_campo_form = "hidden";
				break;

			case "custom_macro":
				$tipo_campo_form = "custom_macro";
				break;
				
			case "parse_value":
				$tipo_campo_form = "parse_value";
				break;
			
			case "file":
				$tipo_campo_form = "file";
				break;
			
			case "solo_testo":
				$tipo_campo_form = "solo_testo";
				break;
			
			case "html":
				$tipo_campo_form = "html";
				break;
				
			
			default:
				$tipo_campo_form = "text";
				break;
		}
		
		return $tipo_campo_form;
	}
	

	/**
	 * ritorna l'html di una label per il campo in oggetto
	 * 
	 * @return string html da stampare nel blade
	 */
	public function print_label(){
		return \Form::label($this->nome_campo, $this->etichetta, ['class' => 'col-sm-3 control-label '.join(" ", $this->classi_etichetta)]);
	}

	
	/**
	 * ritorna l'html del campo in oggetto per la modalita' edit, quindi input text, textarea, etc.
	 * 
	 * @param type $existing_obj
	 * @param array $options
	 * @return string html da stampare nel blade
	 * @throws Exception
	 */
	public function print_input_field($existing_obj, $options = []){

		$out = "";
		
		if(!is_array($options)){
			throw new Exception("options must be an array, ".gettype($options)." given");
		}
		
		$skip_enclosure = isset($options["skip_enclosure"]) ? $options["skip_enclosure"] : false;
		
		if(!$skip_enclosure){
			$out .= "<div class='edit_form_field'>";
		}
		

		if($this->tipo_campo_form() == "password"){
			$out .= Form::{$this->tipo_campo_form()}($this->nome_campo, array_merge(['class' => 'form-control '.join(" ", $this->classi_html), 'placeholder' => $this->placeholder], $this->attributes));
			$out .= Form::{$this->tipo_campo_form()}($this->nome_campo."_confirmation", ['class' => 'form-control '.join(" ", $this->classi_html), 'placeholder' => $this->nome_campo." confirmation"]);
		}elseif($this->tipo_campo_form() == "file"){

			$out .= Form::{$this->tipo_campo_form()}($this->nome_campo, array_merge(['class' => 'form-control '.join(" ", $this->classi_html), 'placeholder' => $this->placeholder], $this->attributes));
		}elseif($this->tipo_campo_form() == "select"){

			$out .= Form::{$this->tipo_campo_form()}($this->nome_campo, $this->opzioni_select, $this->valore_fisso, array_merge(['class' => 'form-control '.join(" ", $this->classi_html)], $this->attributes));
		}elseif($this->tipo_campo_form() == "checkbox" || $this->tipo_campo_form() == "radio"){

			$out .= Form::{$this->tipo_campo_form()}($this->nome_campo, 1, $this->is_checked, array_merge(['class' => ''.join(" ", $this->classi_html)], $this->attributes));
		}elseif($this->tipo_campo_form() == "custom_macro"){

			$out .= $existing_obj->{$this->nome_campo."_macro"}();
			$out .= Form::{$this->nome_campo}();
		}elseif($this->tipo_campo_form() == "parse_value"){

			$out .= Form::text($this->nome_campo, $existing_obj->{$this->parse_function}($this->nome_campo), array_merge(['class' => 'form-control '.join(" ", $this->classi_html), 'placeholder' => $this->placeholder], $this->attributes));
		}elseif($this->tipo_campo_form() == "solo_testo"){

			$out .= "<div class='".join(" ", $this->classi_html)."'>";
			$out .= $this->nome_campo;
			$out .= "</div>";
		}elseif($this->tipo_campo_form() == "html"){

			$out .= $this->valore_fisso;
		}elseif($this->tipo_campo_form() == "hidden"){

			$out .= Form::{$this->tipo_campo_form()}($this->nome_campo, $this->valore_fisso, array_merge(['class' => 'form-control '.join(" ", $this->classi_html), 'placeholder' => $this->placeholder], $this->attributes));
		}else{

			$out .= Form::{$this->tipo_campo_form()}($this->nome_campo, $this->valore_fisso, array_merge(['class' => 'form-control '.join(" ", $this->classi_html), 'placeholder' => $this->placeholder], $this->attributes));
		}

		if(!$skip_enclosure){
			$out .= "</div>";
		}
		
		return $out;
	}
	
	
	/**
	 * ritorna l'html del valore del campo in oggetto da usare nella modalita' view
	 * 
	 * @param type $existing_obj
	 * @param array $options
	 * @return string
	 * @throws Exception
	 */
	public function print_view_field($existing_obj, $options = []){
		
		$out = "";
		
		if(!is_array($options)){
			throw new Exception("options must be an array, ".gettype($options)." given");
		}
		
		$valore = "";
		
		switch($this->tipo_campo_form()){
			
			case "select":
				
				$valore = isset($this->opzioni_select[$existing_obj->{$this->nome_campo}]) ? $this->opzioni_select[$existing_obj->{$this->nome_campo}] : "";
				break;

			default:
				
				$valore = $existing_obj->{$this->nome_campo};
				break;
		}
		
		$skip_enclosure = isset($options["skip_enclosure"]) ? $options["skip_enclosure"] : false;
		$prevent_hidden_attr = isset($options["prevent_hidden_attr"]) ? $options["prevent_hidden_attr"] : true;
		
		if(!$skip_enclosure){
			$out .= "<div class='view_form_field vff_style'>";
		}
		
				
		if(!$prevent_hidden_attr || array_search($this->nome_campo, $existing_obj->hidden_list()) === false){
			$out .= "<span>".$valore."</span>";
		}
		
		
		if(!$skip_enclosure){
			$out .= "</div>";
		}
		
		return $out;
	}
	
	
	public function print_all_field($existing_obj, $options = []){
		return $this->print_view_field($existing_obj, $options).$this->print_input_field($existing_obj, $options);
	}
}