<?php

//namespace JSM\Base;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;
use App\Strumenti\Librerie;
use App\Strumenti;

abstract class jsmModel extends Model{

	use ValidatingTrait;
	protected $rules = [];

	public $oggetti_relazione = [];  //serve per la funzione get_relation_attribute


	protected $validationMessages = [
		"numeric" => "Il campo &quot;:attribute&quot; deve essere numerico",
		"integer" => "Il campo &quot;:attribute&quot; deve contenere un numero intero",
		"date_nullable" => "Inserire una data valida (gg/mm/aaaa | aaaa-mm-gg) oppure lasciare vuoto il campo",
		"numeric_nullable" => "Inserire un valore numerico oppure lasciare vuoto il campo",
		"required" => " ",
	];

	
	public function __construct(array $attributes = []){
		
		//settiamo il formato della data se siamo su Linux e il DB e' SQL Server, altrimenti Carbon non riesce a costruire l'oggetto datetime correttamente
		if(config("database.default", "mysql") === "sqlsrv" && (php_uname("s") === "Linux" || env("OS") === "Linux")){
			$this->dateFormat = 'Y-m-d H:i:s';
		}
		
		parent::__construct($attributes);
	}
	
	
	/**
	 * estendiamo il metodo base per fare in modo di processare gli input applicando le nostre conversioni prima di validare i dati
	 * 
	 * @param type $key
	 * @return type
	 */
	public function getAttributeValue($key){

		$val = parent::getAttributeValue($key);
		
		if(is_string($val)){
			self::parse_input_saving($this->getModel(), $key, $val);
		}
		
		return $val;
	}
	

	public static function boot(){
		
		parent::boot();

		static::creating(function($model){
			foreach($model->attributes as $key => $value){
				
				self::parse_input_saving($model, $key, $value);
//				$model->{$key} = empty($value) && $value !== 0 && $value !== 0.0 && $value !== "0" ? null : $value;
				$model->{$key} = $value;
			}
		});

		static::updating(function($model){
			
			foreach($model->attributes as $key => $value){
				
				self::parse_input_saving($model, $key, $value);
//				$model->{$key} = empty($value) && $value !== 0 && $value !== 0.0 && $value !== "0" ? null : $value;
				$model->{$key} = $value;
			}
			
		});
		
		
		/*
		 * aggiungiamo i log di default per i 3 metodi standard: create, update e delete
		 */
		
		static::created(function($model){
			
			/*
			 * log locali
			 */
			try{

				$reflect = new \ReflectionClass($model);
				
				if(class_exists("jsmLog") === false || array_search($reflect->getShortName(), jsmLog::$excluded_class) !== false){
					return;
				}
				
				$info = array();
				$info["id"] = $model !== null ? $model->getKey() : null;
				$info["file_name"] = $reflect->getFileName();

				jsmLog::log_event("create ".$reflect->getShortName(), "insert", $info, $model);
				
			}catch(\Exception $ex){
				Log::error("Errore creazione log: ".$ex->getMessage());
				
				if(config('app.debug')){
					throw $ex;
				}
			}
			
			
			/*
			 * log documentazione
			 */
			try{

				if(class_exists("jsmDoc") === false){
					return;
				}
				
				$reflect = new \ReflectionClass($model);
				jsmDoc::log_method("created", $reflect->getName(), $reflect->getFileName(), null, __FILE__);
				
			}catch(\Exception $ex){
				Log::error("Errore creazione documentazione: ".$ex->getMessage());
				
				if(config('app.debug')){
					throw $ex;
				}
			}
			
		});
		
		
		static::updated(function($model){
			
			/*
			 * log locali
			 */
			try{

				$reflect = new \ReflectionClass($model);
				
				if(class_exists("jsmLog") === false || array_search($reflect->getShortName(), jsmLog::$excluded_class) !== false){
					return;
				}
				
				$info = array();
				$info["id"] = $model !== null ? $model->getKey() : null;
				$info["file_name"] = $reflect->getFileName();

				jsmLog::log_event("update ".$reflect->getShortName(), "update", $info, $model);
				
			}catch(\Exception $ex){
				Log::error("Errore creazione log: ".$ex->getMessage());
				
				if(config('app.debug')){
					throw $ex;
				}
			}
			
			
			/*
			 * log documentazione
			 */
			try{

				if(class_exists("jsmDoc") === false){
					return;
				}
				
				$reflect = new \ReflectionClass($model);
				jsmDoc::log_method("updated", $reflect->getName(), $reflect->getFileName(), null, __FILE__);
				
			}catch(\Exception $ex){
				Log::error("Errore creazione documentazione: ".$ex->getMessage());
				
				if(config('app.debug')){
					throw $ex;
				}
			}
			
		});
		
		
		static::deleted(function($model){
			
			try{

				$reflect = new \ReflectionClass($model);
				
				if(class_exists("jsmLog") === false || array_search($reflect->getShortName(), jsmLog::$excluded_class) !== false){
					return;
				}
				
				$info = array();
				$info["id"] = $model !== null ? $model->getKey() : null;
				$info["file_name"] = $reflect->getFileName();

				jsmLog::log_event("delete ".$reflect->getShortName(), "delete", $info, $model);
				
			}catch(\Exception $ex){
				Log::error("Errore creazione log: ".$ex->getMessage());
				
				if(config('app.debug')){
					throw $ex;
				}
			}
			
			
			/*
			 * log documentazione
			 */
			try{

				if(class_exists("jsmDoc") === false){
					return;
				}
				
				$reflect = new \ReflectionClass($model);
				jsmDoc::log_method("deleted", $reflect->getName(), $reflect->getFileName(), null, __FILE__);
				
			}catch(\Exception $ex){
				Log::error("Errore creazione documentazione: ".$ex->getMessage());
				
				if(config('app.debug')){
					throw $ex;
				}
			}
		});
	}

	
	/**
	 * la funzione trasforma il dato ricevuto sulla base del tipo in modo che venga salvato correttamente su DB
	 * 
	 * @param type $model
	 * @param type $key
	 * @param type $value
	 */
	public static function parse_input_saving($model, $key, &$value){
		
		$type = '';
		
		if(isset($model->types[$key])){
				
			$type = $model->types[$key];

			if(!empty($value)){
				switch($type){

					case "float":

						if(strpos($value, ".") !== false && strpos($value, ",") !== false){

							$value = str_replace(".", "", $value);
							$value = str_replace(",", ".", $value);

						}elseif(strpos($value, ",") !== false){ //se c'e' solo la virgola, sostituiamola con il punto
							$value = str_replace(",", ".", $value);
						}

						break;

					case "valuta":

						if(strpos($value, ".") !== false && strpos($value, ",") !== false){

							$value = str_replace(".", "", $value);
							$value = str_replace(",", ".", $value);

						}elseif(strpos($value, ",") !== false){ //se c'e' solo la virgola, sostituiamola con il punto
							$value = str_replace(",", ".", $value);

						}elseif(strpos($value, ".") !== false){ //se c'e' solo il punto, ipotizziamo che la valuta abbia al massimo due cifre decimali

							$arr = explode(".", $value);

							if(strlen($arr[1]) === 3){ //dovrebbero essere le migliaia, quindi togliamo il punto
								$value = str_replace(".", "", $value);
							}

						}

						break;

					case "date":

						$value = classe_data::format_data($value);
						break;

					default:
						break;
				}
			}
		}
		
		if($type !== 'empty_string'){
			$value = (empty($value) && $value !== 0 && $value !== 0.0 && $value !== "0" ? null : $value);
		}
		
	}
	

	/**
	 * genera automaticamente l'elenco delle option di un menu a tendina
	 * 
	 * @param string $nome il campo di cui stampare il valore;<br />
	 * puo' essere: il nome di un campo del modello corrente; una relazione getRelazione.nome_campo; un metodo get_nome()
	 * @param type $valore
	 * @param type $campo_ordine
	 * @param type $allow_empty
	 * @return type
	 */
	public static function option_select($nome, $valore, $campo_ordine="", $allow_empty = true, $metodo_filtro = NULL, $opzioni_filtro = array()){
		
		$result = array();
		if($allow_empty){
			$result[""] = "--";
		}

		$table_name = with(new static)->getTable();
		$custom_sort = true;

		if(strlen($campo_ordine) == 0 || !in_array($campo_ordine, \Schema::getColumnListing($table_name))){
			$campo_ordine = \Schema::getColumnListing($table_name)[0];
			$custom_sort = false;
		}

//		foreach(self::orderBy($campo_ordine)->get() as $value){
//			$result[$value->$valore] = $value->$nome;
//		}
		
		$obj = self::orderBy($campo_ordine);
//		self::applica_permessi($obj);
		
		$nome_classe = get_called_class(); //in questo modo recuperiamo l'istanza della classe figlia
		$nome_classe::applica_permessi($obj);
		
				
		if(method_exists($nome_classe, $metodo_filtro)){
			$nome_classe::$metodo_filtro($obj, $opzioni_filtro);			
		}
		
		$is_metodo = false;
		if(strpos($nome, "()") !== false){
			$is_metodo = true;
			$nome = str_replace("()", "", $nome);
		}
//		echo debug_query($obj);
//		die();
		foreach($obj->get() as $value){
			if($is_metodo){
				$result[$value->$valore] = $value->{$nome}();
			}else{
				$result[$value->$valore] = $value->{$nome};
			}
		}
		
		if(!$custom_sort){
			asort($result);
		}
		
		return $result;
	}
	
	
	public static function option_select_si_no($allow_empty = true){
		
		$result = array();
		if($allow_empty){
			$result[""] = "--";
		}
		
		$result[0] = 'No';
		$result[1] = 'S&igrave;';
		
		
		return $result;
	}
	
	
	
	public static function applica_permessi(&$builder_obj, $user_obj = null){
		/*
		 * questo metodo funge solo da placeholder, ogni modello che vuole implementare i permessi dovra' estendere questo metodo
		 */
	}

	
	public function stampa_data($nome_campo, $options = array()){
		return classe_data::stampa_data($this->$nome_campo, $options);
	}
	
	public function stampa_dataTime($nome_campo){
		return classe_data::stampa_dataTime($this->$nome_campo);
	}
	
	public function stampa_valuta($nome_campo, $thousand = true, $euro = false){
		
		//se il campo passato fa parte di una relazione (es: getOggetto.nome), chiamiamo la funzione e quindi l'attributo
		if(strpos($nome_campo, ".") !== false){
			$rel = explode(".", $nome_campo)[0];
			$nome_campo = explode(".", $nome_campo)[1];
			
			$value = $this->$rel->$nome_campo;
		}else{
			$value = $this->$nome_campo;
		}
		$formatted = $value;
		if(is_numeric($value)){
			$formatted = number_format($value, "2", ",", ($thousand ? "." : ""));
			
			if($euro){
				$formatted .= " &euro;";
			}
		}
		
		return $formatted;
	}
	
	
	public function fillable_list(){
		return $this->fillable;
	}

	public function hidden_list(){
		return $this->hidden;
	}
	
}
