<?php

namespace JSM\Base\Scopes;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

/**
 * permette di gestire il softDelete su un campo che non sia una data, ma tinyInteger 0/1 dove 0 => cancellato, 1 => attivo
 */
class SoftDeletingBooleanInvertedScope implements \Illuminate\Database\Eloquent\Scope
{
    /**
     * All of the extensions to be added to the builder.
     *
     * @var array
     */
    protected $extensions = ['Restore', 'WithTrashed', 'WithoutTrashed', 'OnlyTrashed'];

    /**
     * Apply the scope to a given Eloquent query builder.
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $builder
     * @param  \Illuminate\Database\Eloquent\Model  $model
     * @return void
     */
    public function apply(Builder $builder, Model $model)
    {
//        $builder->whereNull($model->getQualifiedDeletedAtColumn());
//        $builder->where($model->getQualifiedDeletedAtColumn(), 0);
		$builder->where($model->getQualifiedDeletedAtColumn(), 1);
    }

    /**
     * Extend the query builder with the needed functions.
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $builder
     * @return void
     */
    public function extend(Builder $builder)
    {
        foreach ($this->extensions as $extension) {
            $this->{"add{$extension}"}($builder);
        }

        $builder->onDelete(function (Builder $builder) {
            $column = $this->getDeletedAtColumn($builder);

            return $builder->update([
//                $column => $builder->getModel()->freshTimestampString(),
//                $column => 1,
				$column => 0,
            ]);
        });
    }

    /**
     * Get the "deleted at" column for the builder.
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $builder
     * @return string
     */
    protected function getDeletedAtColumn(Builder $builder)
    {
        if (count((array) $builder->getQuery()->joins) > 0) {
            return $builder->getModel()->getQualifiedDeletedAtColumn();
        }

        return $builder->getModel()->getDeletedAtColumn();
    }

    /**
     * Add the restore extension to the builder.
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $builder
     * @return void
     */
    protected function addRestore(Builder $builder)
    {
        $builder->macro('restore', function (Builder $builder) {
            $builder->withTrashed();

//            return $builder->update([$builder->getModel()->getDeletedAtColumn() => null]);
//            return $builder->update([$builder->getModel()->getDeletedAtColumn() => 0]);
			return $builder->update([$builder->getModel()->getDeletedAtColumn() => 1]);
			
		});
    }

    /**
     * Add the with-trashed extension to the builder.
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $builder
     * @return void
     */
    protected function addWithTrashed(Builder $builder)
    {
        $builder->macro('withTrashed', function (Builder $builder) {
            return $builder->withoutGlobalScope($this);
        });
    }

    /**
     * Add the without-trashed extension to the builder.
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $builder
     * @return void
     */
    protected function addWithoutTrashed(Builder $builder)
    {
        $builder->macro('withoutTrashed', function (Builder $builder) {
            $model = $builder->getModel();

//            $builder->withoutGlobalScope($this)->whereNull(
//                $model->getQualifiedDeletedAtColumn()
//            );
//            $builder->withoutGlobalScope($this)->where(
//                $model->getQualifiedDeletedAtColumn(), 0
//            );
			$builder->withoutGlobalScope($this)->where(
                $model->getQualifiedDeletedAtColumn(), 1
            );
			
            return $builder;
        });
    }

    /**
     * Add the only-trashed extension to the builder.
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $builder
     * @return void
     */
    protected function addOnlyTrashed(Builder $builder)
    {
        $builder->macro('onlyTrashed', function (Builder $builder) {
            $model = $builder->getModel();

//            $builder->withoutGlobalScope($this)->whereNotNull(
//                $model->getQualifiedDeletedAtColumn()
//            );
//			$builder->withoutGlobalScope($this)->where(
//                $model->getQualifiedDeletedAtColumn(), 1
//            );
			$builder->withoutGlobalScope($this)->where(
                $model->getQualifiedDeletedAtColumn(), 0
            );

            return $builder;
        });
    }
}