<?php

/**
 * Permette di creare un oggetto con le informazioni per poi renderizzare un bottone html
 *
 * @author fabio
 */
class bottoni_html{
	
	protected $href;
	protected $title;
	protected $classes = [];
	protected $html_text;


	public function __construct($classi_btn_standard = true){
		
		/*
		 * log documentazione
		 */
		if(class_exists("jsmDoc")){

			try{

				$reflect = new \ReflectionClass($this);
				\jsmDoc::log_method(__FUNCTION__, $reflect->getName(), $reflect->getFileName(), null, __FILE__);

			}catch(\Exception $ex){
				\Log::error("Errore creazione documentazione: ".$ex->getMessage());

				if(config('app.debug')){
					throw $ex;
				}
			}
		}
		
		
		$this->href = "#";
		$this->title = null;
		$this->html_text = "";
		
		if($classi_btn_standard){
			$this->classes[] = "btn";
		}
		
	}

	public function get_href(){
		return $this->href;
	}

	public function get_title(){
		return $this->title ?? $this->html_text;
	}

	public function get_classes(){
		return join(" ", $this->classes);
	}

	public function get_html_text(){
		return $this->html_text;
	}
	
	

	public function set_href($href){
		$this->href = $href;
	}

	public function set_title($title){
		$this->title = $title;
	}

	public function add_class($class){
		$this->classes[] = $class;
	}

	public function set_html_text($html_text){
		$this->html_text = $html_text;
	}


}
