<?php

namespace JSM\Base\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Session;


class jsmController extends Controller{
	
	protected $bottoni_form = array();
	protected $campi = array();
	protected $route_base_name = "";
	protected $url_base = "";
	protected $url_base_param = "";


	protected $friendly_name = "";
	protected $new_title = "";
	protected $edit_title = "";
	protected $elenco_title = "";
	protected $create_messagge = "";
	protected $edit_messagge = "";
	protected $delete_messagge = "";
	protected $not_found_messagge = "";

	protected $custom_view_param = array();
	protected $edit_mode = null; //serve per definire se la pagina con il form e' in modalita edit o view
	protected $modal_errors = false; //se impostato a TRUE, i metodi ritornano l'errore in finestra modale -- Deprecato
	protected $modal = false; //se impostato a TRUE, i metodi ritornano in finestra modale

	/**
	 * se popolato, questo array di settori viene inizializzato nel metodo edit
	 * @var array|null
	 */
	public $edit_sectors = null;
	/**
	 * se popolato, questo array di settori viene inizializzato nel metodo create
	 * @var array|null
	 */
	public $create_sectors = null;

	/**
	 * abilita l'inizializzazione automatica dei settori nei metodi store e update. Compatibile solo con fieldTypes v4
	 * @var bool
	 */
	public $txd_verification_enabled = false;

	/**
	 *
	 * @var \Illuminate\Database\Eloquent\Model 
	 */
	protected $model_name = "";
	protected $existing_obj = null;
	
	
	
	public function __construct(){
		/* -------------------------------------------------------------------
		 * impostazioni generali usate in tutto il controller
		 */

		
		$this->init_param_info();

		$this->bottoni_form = \campi_form::$bottoni_form; /* recuperiamo i bottoni base per il form di edit e andiamo a modificare i campi necessari */

		/* andiamo a sovrascrivere, eventualmente, il comportamento base dei bottoni */
		$this->bottoni_form["elenco"]["link"] = $this->url_base;
		//$this->bottoni_form["salva"]["etichetta"] = "<i class='fa fa-pencil'></i> Salva";

		/*
		 * ------------------------------------------------------------------- */
	}
	
	
	/**
	 * permette di aggiungere all'array custom_view_param una coppia chiave => valore <br>
	 * che i vari metodi passeranno alle viste in aggiunta ai parametri info standard
	 * 
	 * @param string $nome
	 * @param string $valore
	 */
	public function add_view_param($nome, $valore){
		$this->custom_view_param[$nome] = $valore;
	}
	
	
	/**
	 * re-inizializza i nomi dei vari attributi, in modo da poterli richiamare nei vari metodi e avere accesso alla sessione
	 * 
	 * ATTENZIONE! Va ridefinito nei vari controller in modo da sostituire correttamente le informazioni
	 */
	public function init_param_info(){
		
		$model_guess_name = str_replace("Controller", "", basename(str_replace("\\", "/", get_class($this)))); //quest non va ripetuto nel controller esteso
		
		$this->url_base = url("/path");   /* definiamo il percorso base di tutti gli url presenti nella pagina */
		$this->model_name = "App\Models\\".$model_guess_name; /* definiamo il nome completo del modello da usare in tutti i metodi (quantomeno quelli base) */
		
		$this->friendly_name = stampa("Name", false);
		$this->elenco_title = stampa("Name list", false);
		$this->new_title = stampa("New ".$this->friendly_name, false);
		$this->edit_title = stampa("Edit ".$this->friendly_name, false);
		$this->create_messagge = stampa($this->friendly_name." created", false);
		$this->edit_messagge = stampa($this->friendly_name." updated", false);
		$this->delete_messagge = stampa($this->friendly_name." deleted", false);
		$this->not_found_messagge = stampa($this->friendly_name." not found", false);
	}
	
	
	/**
	 * definisce quali sono i campi da mostrare nei form di insert / edit, da chiamare negli opportuni metodi<br />
	 * in questo modo possiamo accedere anche alle informazioni di sessione (ad esempio gli utenti loggati!)
	 * 
	 */
	public function init_form_fields($insert = false){
		/*
		 * creiamo l'array con i campi da passare al visualizzatore di form (insert/edit)
		 */		
		
		
	}
	
	
	
	/**
	 * Display a listing of the resource.
	 * GET /[route]
	 *
	 * @return Response
	 */
	public function index(){
		
		$model_name = $this->model_name;
		
		/*
		 * controllo permessi
		 */
		if (\Auth::user() === null || \Auth::user()->cant('access', $this->model_name)) {
			return view("errors.error_page", $this->custom_view_param);
		}
		
		$obj = new $model_name;
		$query = $model_name::getQuery();
		
		$model_name::applica_permessi($query);
		
		$grid = \jsmDataGrid::source($query);
		
		foreach(array_slice($obj->getModel()->fillable_list(), 0, 10) as $key){
			$grid->add($key, $key);
		}
		
		$grid->paginate(50);
		
		$info = compact('grid');
		$info["titolo"] = $this->elenco_title."&nbsp;&nbsp;&nbsp;&nbsp;<span style='font-size: 16px; font-style: italic;'>[i primi 10 campi raccolti automaticamente]</span>";
		$info["bottone_new"] = "<i class='fa fa-plus'></i>&nbsp;&nbsp;".$this->new_title;
		$info["url_create"] = $this->url_base."/create";
		$info["classe_box"] = "box-primary";
		

		return view('moduli.pagina_elenco', array_merge(array("info" => $info), $this->custom_view_param));
	}


	/**
	 * funzione che carica il modello corrente nell'attributo ->existing_obj del controller.
	 * ritorna 0 in caso di successo, o un codice numerico in caso di errore:
	 * 	1- Modello non trovato
	 *  2- Permessi negati
	 * 
	 * @param mixed $id
	 * @param string $permission
	 * 
	 * @return int
	 */
	public function load_existing_obj($id,$permission = "view",$allow_new = false){
		$model_name = $this->model_name;
		if(!is_a($this->existing_obj, $model_name)){ //in questo modo e' possibile instanziare l'oggetto nel metodo esteso e settare delle proprieta'
			if(is_null($id)){
				$this->existing_obj = new $model_name();
			}else{
				try{
					$this->existing_obj = $model_name::findOrFail($id);
				}catch(\Exception $e){
					$this->existing_obj = new $model_name();
				}
			}
        }

		if(!$allow_new && !$this->existing_obj->exists){
			return 1; //not found;   
        }

		/*
		 * controllo permessi
		 */
		if (\Auth::user() === null || \Auth::user()->cant($permission, $this->existing_obj)) {
			return 2; //permission denied
		}

		return 0;
	}
	
	
	/**
	 * Show the form for creating a new resource.
	 * GET /[route]/create
	 *
	 * @return Response
	 */
	public function create($landing_view = ""){
		
		/*
		 * log documentazione
		 */
		if(class_exists("jsmDoc")){

			try{

	//			$info = array();
	//			$info["name"] = $reflect->getName();
	//			$info["file_name"] = $reflect->getFileName();
				
	//			\jsmDoc::log_method(__FUNCTION__, get_class($this), __FILE__, $info);
				$reflect = new \ReflectionClass($this);
				\jsmDoc::log_method(__FUNCTION__, $reflect->getName(), $reflect->getFileName(), null, __FILE__);

			}catch(\Exception $ex){
				Log::error("Errore creazione documentazione: ".$ex->getMessage());

				if(config('app.debug')){
					throw $ex;
				}
			}
		}

		$esito = $this->load_existing_obj(null,"create",true);
		$existing_obj = $this->existing_obj; //in questo modo non si rompe il compact
		
		switch($esito){
			case 0:
				break;
			case 2: // permission denied
			default:
				return view("errors.error_page".(($this->modal||$this->modal_errors) ? "_modal" : ""), $this->custom_view_param);
		}
		
		
        $this->init_form_fields(true);
        
        //se non abbiamo valorizzato a mano l'array con i campi specifici andiamo a popolarlo con i campi di tutte le sezioni del modello
        if(is_array($this->campi) && count($this->campi) == 0 && method_exists($this->existing_obj, "get_campi")){
            $this->campi = $this->existing_obj->get_campi($this->create_sectors ?? $this->edit_sectors ?? []);
        }
		
		$info = array(
			"titolo_pagina" => $this->new_title,
			"main_title" => true,
			"url" => ($this->url_base),
			"campi" => $this->campi,
			//"campi_avanzati" => $this->campi2,
			"bottoni_form" => $this->bottoni_form,
			"obj" => compact('existing_obj'),
		);

		return view((strlen($landing_view) > 0 ? $landing_view : ($this->modal===true?"moduli.edit_form_modal_v2":"moduli.edit_form_table")), array_merge($info, $this->custom_view_param));
	}

	
	/**
	 * Store a newly created resource in storage.
	 * POST /[route]
	 *
	 * @param Request $request
	 * @return Response
	 */
	public function store(Request $request, $landing_page = ""){
		
		/*
		 * log documentazione
		 */
		if(class_exists("jsmDoc")){
			try{

	//			$info = array();
	//			$info["name"] = $reflect->getName();
	//			$info["file_name"] = $reflect->getFileName();
				
	//			\jsmDoc::log_method(__FUNCTION__, get_class($this), __FILE__, $info);
				$reflect = new \ReflectionClass($this);
				\jsmDoc::log_method(__FUNCTION__, $reflect->getName(), $reflect->getFileName(), null, __FILE__);

			}catch(\Exception $ex){
				Log::error("Errore creazione documentazione: ".$ex->getMessage());

				if(config('app.debug')){
					throw $ex;
				}
			}
		}
		$out = array("stato"=>"KO","message"=>"","campi_errati"=>[]);
		/*
		 * controllo permessi
		 */
		$esito = $this->load_existing_obj(null,"create",true);
		switch($esito){
			case 0: // OK
				break;
			case 2: // permission denied
			default:
				if($this->modal === true){
					$out["stato"] = "KO";
					$out["message"] = "Permission Denied!";
					return json_encode($out);
				}else{
					return view("errors.error_page".(($this->modal||$this->modal_errors) ? "_modal" : ""), $this->custom_view_param);
				}
		}
		
		$requestData = $request->input();
        
        
        
        if(method_exists($this->existing_obj, "init_db_fields")){ //serve per popolare i fillable nella nuova modalita' txdAttributes
            $sectors = null;
			if($this->txd_verification_enabled){
				$token = request()->input("txd_verification");
				$sectors = \Txd\txdFields::getVerificationTokenMatch($token, $this->modal);
				if(is_null($sectors)){
					Session::flash("error_saving", true);
					if($this->modal === true){
						$out["stato"] = "KO";
						$out["message"] = stampa("Errore nel salvataggio, riprovare", false);
						$out["campi_errati"] = [];
						return json_encode($out);
					}else{
						return redirect($this->url_base.'/create'.$this->url_base_param)
							->withErrors(new \Illuminate\Support\MessageBag())
							->withInput();
					}
				}
				$prevAutoapplyValue = \Txd\txdFields::$AUTO_APPLY_DB_FIELDS;
				\Txd\txdFields::$AUTO_APPLY_DB_FIELDS = false;
			}
            $this->existing_obj->init_db_fields();
			
			if($this->txd_verification_enabled){
				$this->existing_obj->inizializzaCampi($sectors);
				\Txd\txdFields::$AUTO_APPLY_DB_FIELDS = $prevAutoapplyValue;
			}
        }

        $this->existing_obj->fill($requestData);
        $this->existing_obj->save();

//		Session::flash("existing_obj", $existing_obj);

		if($this->existing_obj->isValid()){
			Session::flash('flash_message', '<div class="alert alert-success auto_close">'.$this->create_messagge.stampa(' con successo', FALSE).'!</div>');
			if($this->modal === true){
				$out["stato"] = "OK";
				return json_encode($out);
			}else{
				return redirect((strlen($landing_page) > 0 ? $landing_page : route($this->route_base_name.".show",$this->existing_obj->getKey()).$this->url_base_param));
			}
		}else{
			Session::flash("error_saving", true);
//			Session::flash("existing_obj", $this->existing_obj);
			if($this->modal === true){
				$out["stato"] = "KO";
				$out["message"] = stampa("Errore nel salvataggio", false);
				$out["campi_errati"] = $this->existing_obj->getErrors()->keys();
				return json_encode($out);
			}else{
				return redirect($this->url_base.'/create'.$this->url_base_param)
							->withErrors($this->existing_obj->getErrors())
							->withInput();
			}
		}		
	}

	
	

	/**
	 * Display the specified resource.
	 * GET /[route]/{id}
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function show($id){
		
		/*
		 * log documentazione
		 */
		if(class_exists("jsmDoc")){
			try{
				$reflect = new \ReflectionClass($this);
				\jsmDoc::log_method(__FUNCTION__, $reflect->getName(), $reflect->getFileName(), null, __FILE__);

			}catch(\Exception $ex){
				Log::error("Errore creazione documentazione: ".$ex->getMessage());

				if(config('app.debug')){
					throw $ex;
				}
			}
		}
		
		if(config("jsm_log.log_show_enabled",false)){
			$shortname = explode('\\', $this->model_name)[0] ?? $this->model_name;
			if(class_exists("jsmLog") && array_search($shortname, \jsmLog::$excluded_class) === false){
				try{

					\jsmLog::log_event("view ".$shortname, "view");

				}catch(\Exception $ex){
					Log::error("Errore creazione log: ".$ex->getMessage());

					if(config('app.debug')){
						throw $ex;
					}
				}
			}
		}
		
		$this->edit_mode = 0; //impostiamo la modalita' view
		
		return $this->edit($id);
	}

	
	/**
	 * Show the form for editing the specified resource.
	 * GET /[route]/{id}/edit
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function edit($id, $landing_view = ""){
		
		/*
		 * log documentazione
		 */
		
		if(class_exists("jsmDoc")){
			try{
				$reflect = new \ReflectionClass($this);
				\jsmDoc::log_method(__FUNCTION__, $reflect->getName(), $reflect->getFileName(), null, __FILE__);

			}catch(\Exception $ex){
				Log::error("Errore creazione documentazione: ".$ex->getMessage());
				if(config('app.debug')){
					throw $ex;
				}
			}
		}
		
		$esito = $this->load_existing_obj($id,"view");
		$existing_obj = $this->existing_obj; //in questo modo non si rompe il compact
		
		switch($esito){
			case 0: // OK
				break;
			case 1: // not found
				return view("errors.error_page".(($this->modal||$this->modal_errors) ? "_modal" : ""), array_merge(["messaggio" => stampa("Item not found or not saved!", false)], $this->custom_view_param));
			case 2: // permission denied
			default:
				return view("errors.error_page".(($this->modal||$this->modal_errors) ? "_modal" : ""), $this->custom_view_param);
		}
		
		

		$this->init_form_fields();
		// Session::flash("existing_obj", $existing_obj);

        //se non abbiamo valorizzato a mano l'array con i campi specifici andiamo a popolarlo con i campi di tutte le sezioni del modello
        if(is_array($this->campi) && count($this->campi) == 0 && method_exists($this->existing_obj, "get_campi")){
            $this->campi = $this->existing_obj->get_campi($this->edit_sectors ?? []);
        }

		$info = array(
			"titolo_pagina" => $this->edit_title,
			"main_title" => true,
			"url" => ($this->url_base."/".$id),
			"campi" => $this->campi,
			//"campi_avanzati" => $this->campi2,
			"bottoni_form" => $this->bottoni_form,
			"obj" => compact('existing_obj'),
			"edit_mode" => $this->edit_mode,
		);
		
		return view((strlen($landing_view) > 0 ? $landing_view : ($this->modal===true?"moduli.edit_form_modal_v2":"moduli.edit_form_table")), array_merge($info, $this->custom_view_param));
	}

	
	
	/**
	 * Update the specified resource in storage.
	 * PUT /[route]/{id}
	 *
	 * @param int $id
	 * @param Request $request
	 * @return Response
	 */
	public function update(Request $request, $id, $landing_page = ""){

		/*
		 * log documentazione
		 */
		if(class_exists("jsmDoc")){
			try{

				$reflect = new \ReflectionClass($this);
				\jsmDoc::log_method(__FUNCTION__, $reflect->getName(), $reflect->getFileName(), null, __FILE__);

			}catch(\Exception $ex){
				Log::error("Errore creazione documentazione: ".$ex->getMessage());

				if(config('app.debug')){
					throw $ex;
				}
			}
		}
		$out = array("stato"=>"KO","message"=>"","campi_errati"=>[]);
		Session::flash("error_saving", true);
		$model_name = $this->model_name;

		$esito = $this->load_existing_obj($id,"update");
		
		switch($esito){
			case 0: // OK
				break;
			case 1: // not found
				if($this->modal === true){
					$out["stato"] = "KO";
					$out["message"] = "Item Not Found!";
					return json_encode($out);
				}else{
					return view("errors.error_page".(($this->modal||$this->modal_errors) ? "_modal" : ""), array_merge(["messaggio" => stampa("Item not found!", false)], $this->custom_view_param));
				}
			case 2: // no access (fallimento permessi)
				if($this->modal === true){
					$out["stato"] = "KO";
					$out["message"] = "Permission Denied!";
					return json_encode($out);
				}else{
					return view("errors.error_page".(($this->modal||$this->modal_errors) ? "_modal" : ""), $this->custom_view_param);
				}
			default:
				return view("errors.error_page".(($this->modal||$this->modal_errors) ? "_modal" : ""), $this->custom_view_param);
		}
	

		$requestData = $request->input();
        
		
        if(!is_a($this->existing_obj, $model_name)){ //in questo modo e' possibile instanziare l'oggetto nel metodo esteso e settare delle proprieta'
            try{
                $this->existing_obj = $existing_obj = $model_name::findOrFail($id);
            }catch(\Exception $e){
                $this->existing_obj = new $model_name();
            }
        }
 
        if(method_exists($this->existing_obj, "init_db_fields")){ //serve per popolare i fillable nella nuova modalita' txdAttributes
            $sectors = null;
			if($this->txd_verification_enabled){
				$token = request()->input("txd_verification");
				$sectors = \Txd\txdFields::getVerificationTokenMatch($token, $this->modal);
				if(is_null($sectors)){
					Session::flash("error_saving", true);
					if($this->modal === true){
						$out["stato"] = "KO";
						$out["message"] = stampa("Errore nel salvataggio, riprovare", false);
						$out["campi_errati"] = [];
						return json_encode($out);
					}else{
						return redirect($this->url_base.'/'.$id.'/edit'.$this->url_base_param)
									->withErrors(new \Illuminate\Support\MessageBag())
									->withInput();
					}
				}
				$prevAutoapplyValue = \Txd\txdFields::$AUTO_APPLY_DB_FIELDS;
				\Txd\txdFields::$AUTO_APPLY_DB_FIELDS = false;
			}
            $this->existing_obj->init_db_fields();
			
			if($this->txd_verification_enabled){
				$this->existing_obj->inizializzaCampi($sectors);
				\Txd\txdFields::$AUTO_APPLY_DB_FIELDS = $prevAutoapplyValue;
			}
        }
		
		/*
		 * controllo permessi
		 */
		
		
		
		if($this->existing_obj->update($requestData)){
			Session::flash("error_saving", false);
			$out["stato"] = "OK";
		}else{
			
			Session::flash("error_saving", true);
			if($this->modal === true){
				$out["stato"] = "KO";
				$out["message"] = stampa("Errore nel salvataggio", false);
				$out["campi_errati"] = $this->existing_obj->getErrors()->keys();
				return json_encode($out);
			}else{
				return redirect($this->url_base.'/'.$id.'/edit'.$this->url_base_param)
							->withErrors($this->existing_obj->getErrors())
							->withInput();
			}
		}
		
		Session::flash('flash_message', '<div class="alert alert-success data_saved auto_close">'.$this->edit_messagge.stampa(' con successo', FALSE).'!</div>');
		
		if($this->txd_verification_enabled){ //in questo modo bruciamo il token anche da modale che prima non l'ha fatto
			$token = request()->input("txd_verification");
			\Txd\txdFields::getVerificationTokenMatch($token, true);
		}

		if($this->modal === true){
			return json_encode($out);
		}else{
			return redirect((strlen($landing_page) > 0 ? $landing_page : route($this->route_base_name.".show",$this->existing_obj->getKey()).$this->url_base_param));
		}
	}
	
	

	/**
	 * Remove the specified resource from storage.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
	 */
	public function destroy($id, $landing_page = ""){
		
		/*
		 * log documentazione
		 */
		if(class_exists("jsmDoc")){
			try{

	//			$info = array();
	//			$info["name"] = $reflect->getName();
	//			$info["file_name"] = $reflect->getFileName();
				
	//			\jsmDoc::log_method(__FUNCTION__, get_class($this), __FILE__, $info);
				$reflect = new \ReflectionClass($this);
				\jsmDoc::log_method(__FUNCTION__, $reflect->getName(), $reflect->getFileName(), null, __FILE__);

			}catch(\Exception $ex){
				Log::error("Errore creazione documentazione: ".$ex->getMessage());

				if(config('app.debug')){
					throw $ex;
				}
			}
		}
		
		$esito = $this->load_existing_obj($id,"delete");
		switch($esito){
			case 0: // OK
				break;
			case 1:
				if($this->modal === true){
					$out["stato"] = "KO";
					$out["message"] = "Item Not Found!";
					return json_encode($out);
				}else{
					return view("errors.error_page".(($this->modal||$this->modal_errors) ? "_modal" : ""), array_merge(["messaggio" => stampa("Item not found!", false)], $this->custom_view_param));
				}
			case 2:
			default:
				if($this->modal === true){
					$out["stato"] = "KO";
					$out["message"] = "Permission Denied!";
					return json_encode($out);
				}else{
					return view("errors.error_page".(($this->modal||$this->modal_errors) ? "_modal" : ""), $this->custom_view_param);
				}
		}

        $model_name = $this->model_name;
        $model_name::destroy($id);

		Session::flash('flash_message', '<div class="alert alert-success data_saved auto_close">'.$this->delete_messagge.stampa(' con successo', FALSE).'!</div>');
		
		return redirect((strlen($landing_page) > 0 ? $landing_page : $this->url_base));
	}


	/**
	 * sovrascrive le etichette dei bottoni form standard passando la funzione stampa
	 *
	 * @return void
	 */
	protected function translate_form_button(){

		if(($this->bottoni_form["salva"]["etichetta"] ?? "") == "Salva"){
			$this->bottoni_form["salva"]["etichetta"] = stampa("Salva", false);
		}
		if(($this->bottoni_form["modifica"]["etichetta"] ?? "") == "Modifica"){
			$this->bottoni_form["modifica"]["etichetta"] = stampa("Modifica", false);
		}
		if(($this->bottoni_form["annulla"]["etichetta"] ?? "") == "Annulla"){
			$this->bottoni_form["annulla"]["etichetta"] = stampa("Annulla", false);
		}
		if(($this->bottoni_form["elenco"]["etichetta"] ?? "") == "Torna all&apos;elenco"){
			$this->bottoni_form["elenco"]["etichetta"] = stampa("Torna all&apos;elenco", false);
		}
	}
    

	protected $JSM_friendly_name_ita = null;
	protected $JSM_elenco_title_ita = null;
	protected $JSM_gender = null;

	/**
	 * rigenera le traduzioni dei messaggi/testi base in modo da usare la lingua in sessione nei vari metodi dei controller
	 *
	 * @return void
	 */
	protected function translate_common_strings(){

		if(is_null($this->JSM_friendly_name_ita)){
			$this->JSM_friendly_name_ita = trim($this->friendly_name);
		}
		if(is_null($this->JSM_elenco_title_ita)){
			$this->JSM_elenco_title_ita = trim($this->elenco_title);
		}
		if(is_null($this->JSM_gender)){
			$create_message_gender = trim($this->create_messagge);
			if(Str::endsWith($create_message_gender, " con")){
				$create_message_gender = trim(str_replace_last(" con", "", $create_message_gender));
			}

			if(strtolower(substr($create_message_gender, -1)) == "a"){
				$this->JSM_gender = "F";
			}else{
				$this->JSM_gender = "M";
			}
		}

		$this->friendly_name = stampa($this->JSM_friendly_name_ita, false);
		$this->elenco_title = stampa($this->JSM_elenco_title_ita, false);
		$this->new_title = stampa("Nuov".($this->JSM_gender == "F" ? "a" : "o"), false)." ".$this->friendly_name;
		$this->edit_title = stampa("Modifica", false)." ".$this->friendly_name;
		$this->create_messagge = $this->friendly_name." ".stampa("creat".($this->JSM_gender == "F" ? "a" : "o"), false);
		$this->edit_messagge = $this->friendly_name." ".stampa("modificat".($this->JSM_gender == "F" ? "a" : "o"), false);
		$this->delete_messagge = $this->friendly_name." ".stampa("cancellat".($this->JSM_gender == "F" ? "a" : "o"), false);
		$this->not_found_messagge = $this->friendly_name." ".stampa("non trovat".($this->JSM_gender == "F" ? "a" : "o"), false);
	}


    /**
     * estendiamo il metodo base in modo che - se la funzione e' abilitata - venga tracciato il tempo di esecuzione
     * di ogni metodo del controller e inviato al server di raccolta
     *
     * @param [type] $method
     * @param [type] $parameters
     * @return void
     */
    public function callAction($method, $parameters){

        if(class_exists("ExecutionTimeMeasure")){
            $className = str_replace('\\', '.', get_class($this));
            $metric_name = sprintf('%s.%s', $className, $method);
            \ExecutionTimeMeasure::startTiming($metric_name);
        }

		$this->translate_form_button(); //andiamo a chiamare la funzione per tradurre i bottoni di default prima di ogni metodo di ogni controller
		$this->translate_common_strings(); //andiamo a chiamare la funzione per tradurre le stringhe di default prima di ogni metodo di ogni controller

        $response = parent::callAction($method, $parameters);

        if(class_exists("ExecutionTimeMeasure")){
            \ExecutionTimeMeasure::endTiming($metric_name);

            if(!\ExecutionTimeMeasure::isMiddlewareFired()){ //in questo modo se abbiamo fatto partire un timer anche nel middleware lo inviera' lui
                \ExecutionTimeMeasure::send(config("jsm_execution_time_measure.log_to_file", false));
            }
        }

        return $response;
    }
}
