<?php

namespace Txd\Carbon;

use Carbon\Carbon as BaseCarbon;
use Carbon\Exceptions\InvalidFormatException;

class Carbon extends BaseCarbon
{

    public bool $isDatetime = true;
    public bool $isInvalid = false;
    public string $raw = "";

    public static function parse($time = null, $tz = null)
    {
        $formats = ['d/m/Y','d/m/Y H:i:s'];
        foreach($formats as $format){
            try {
                $carbonDate = Carbon::createFromFormat($format, $time, $tz);
                if($carbonDate->getLastErrors()["warning_count"]>0 ||$carbonDate->getLastErrors()["error_count"]>0){
                    throw new InvalidFormatException("");
                }
                if(strlen($time) === 10){
                    $carbonDate->isDatetime = false;
                    $carbonDate->setTime(0,0,0,0);
                }
                return $carbonDate;
            } catch (InvalidFormatException $e) {
                
            }
        }
        try{
            
        return parent::parse($time, $tz);
        }catch(\Throwable $e){
            $invalidCarbon = new Carbon();
            $invalidCarbon->isInvalid = true;
            $invalidCarbon->raw = $time;
            return $invalidCarbon;
        }
    }

    public function is_dataTime($format = null) {
        return $this->isDatetime;
    }

    public function print_data($format = null) {
        return $this->format($format);
    }

    public function format($format = null) {
        if($this->isInvalid) return $this->raw;
        if($format === null){
            $format = config("par.date_format", "d/m/Y");
            if($this->is_dataTime()){
                $format = config("par.datetime_format", $format);
            }
        }
        return parent::format($format);
    }

    public static function stampa_data($data, $options = array()) {
        $format = (isset($options['format']) ? $options['format'] : null);
        $escape = (isset($options['escape']) ? $options['escape'] : "");

        if(is_a($data,static::class)){
            return $data->format($format);
        }
        
        
        if(is_a($data, "DateTime")){			
            $data = $data->format("Y-m-d H:i:s");
        }

        if(strlen($data)==0){
            return "";
        }

//		if(strlen($data)>10){
//			$data = substr($data, 0, 10);
//		}
        
        if($data == $escape){
            return "";
        }

        $data_obj = static::parse($data);
        
        return $data_obj->format($format);
    }
}