<?php

namespace Txd\Core;

use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\Carbon;
use Illuminate\Foundation\AliasLoader;
use Illuminate\Support\ServiceProvider;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Txd\Core\CrudRenderers\BaseCrudRenderer;

/**
 *  *
 * @author Fabio Spadea <fabio@techseed.it>
 */
class TxdCoreServiceProvider extends ServiceProvider
{

    /**
     * Boot the service provider.
     *
     * @return void
     */
    public function boot()
    {
        //caricamento namespace per view
		$this->loadViewsFrom(base_path('resources/views/vendor/txd'), 'txd');
		$this->loadViewsFrom(__DIR__.'/../resources/views', 'txd');

        $this->publishes([
            __DIR__.'/../resources/views' => resource_path('views/vendor/txd'),
        ]);

        Relation::macro("optionSelect",function(){
            return optionSelectHelper($this,...func_get_args());
        });


        $this->publishes([
			__DIR__.'/../../config/txd_url.php' => config_path('txd_url.php'),
		], "txd_url");

        $this->mergeConfigFrom(
			__DIR__.'/../../config/txd_url.php', 'txd_url'
		);


        if(config("txd_url.root_url_from_env")){
            \URL::forceRootUrl(\Config::get('app.url'));
        }

        if(config("txd_url.https_from_env") && isHttpsEnvUrl()){
            \URL::forceScheme('https');
        }
    }

    public function register()
    {
        $this->app->booting(function() {
            $loader = AliasLoader::getInstance();
            $loader->alias('crud_renderer', BaseCrudRenderer::class);
        });
    }

    public function bootCarbonExtensions(){

    }
}
