<?php

namespace Txd\Core;

use Illuminate\Support\Str;

class RouteParameterMapping {
    public string $variableName;
    public string $parameterClass;
    public string $parameterName;

    public function __construct(string $varName, string $fullClassName, string $parName = null)
    {
        $this->variableName = $varName;
        $this->parameterClass = $fullClassName;
        $this->parameterName = $parName ?? Str::singular(Str::snake(substr(strrchr($fullClassName, '\\'), 1)));
    }

}
