<?php

namespace Txd\Relations;

use Closure;

abstract class Relation extends \Illuminate\Database\Eloquent\Relations\Relation {
    public static function withConstraints(Closure $callback)
    {
        $previous = static::$constraints;

        static::$constraints = true;

        // When resetting the relation where clause, we want to shift the first element
        // off of the bindings, leaving only the constraints that the developers put
        // as "extra" on the relationships, and not original relation constraints.
        try {
            return $callback();
        } finally {
            static::$constraints = $previous;
        }
    }
}