<?php

namespace Txd\Settings;


use Txd\Settings\Drivers\Database;
use Exception;
/**
 * @mixin \Illuminate\Contracts\Cache\Repository
 */
class SettingsManager
{
    /**
     * The application instance.
     *
     * @var \Illuminate\Contracts\Foundation\Application
     */
    protected $app;

    /**
     * The array of resolved cache stores.
     *
     * @var array
     */
    protected $drivers = [];

    public static $driverOptions = ["database"=>Database::class];

    /**
     * Create a new Cache manager instance.
     *
     * @param  \Illuminate\Contracts\Foundation\Application  $app
     * @return void
     */
    public function __construct($app)
    {
        $this->app = $app;
        
    }

    /**
     * Get a cache driver instance.
     *
     * @param  Drivers\Driver  $driver
     * @return \Txd\Settings\Drivers\Driver
     */
    public function driver($driver = null)
    {
        if(is_null($driver)){
            $driver = $this->app['config']['settings.default_driver'];
        }
        if(!array_key_exists($driver,$this->drivers)){
            if(array_key_exists($driver,static::$driverOptions)){
                $driverClass = static::$driverOptions[$driver];
                $this->drivers[$driver] = new $driverClass($this->app['config']["settings.drivers.$driver"]);
            }else{
                throw new Exception("Txd\Settings Driver '$driver' not defined",500);
            }
        }
        return $this->drivers[$driver];
    }

    /**
     * Dynamically call the default driver instance.
     *
     * @param  string  $method
     * @param  array  $parameters
     * @return mixed
     */
    public function __call($method, $parameters)
    {
        return $this->driver()->$method(...$parameters);
    }
}
