<?php

namespace Txd\Settings;

use Illuminate\Contracts\Support\DeferrableProvider;
use Illuminate\Support\ServiceProvider;

class SettingsServiceProvider extends ServiceProvider implements DeferrableProvider
{
    public function boot(){
        $migrationPath = __DIR__.'/../../database/migrations/2022_03_09_193005_create_settings_table.php';
        $this->publishes([
            $migrationPath => base_path('database/migrations/2022_03_09_193005_create_settings_table.php'),
        ], 'migrations');
    }
    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $configPath = __DIR__ . '/../../config/settings.php';
        
        $this->mergeConfigFrom($configPath, 'settings');
        $this->publishes([$configPath => config_path('settings.php')], 'config');
        $this->app->singleton('settings', function ($app) {
            return new SettingsManager($app);
        });
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return [
            'settings'
        ];
    }
}
