<?php

namespace Txd\Translation;

use Illuminate\Support\Facades\Cache;
use Illuminate\Translation\FileLoader;

class CachedFileLoader extends FileLoader {
    public function __construct(\Illuminate\Filesystem\Filesystem $files, $path)
    {
        if(!app()->runningInConsole()){
            $value = cache('ltm_translations_version');
            $db_value = settings()->get('ltm_translations_version');
        
            if(empty($value) || empty($db_value) || $value !== $db_value){
                app(\Barryvdh\TranslationManager\Manager::class)->exportAllTranslations();
                Cache::forever('ltm_translations_version',$db_value);
            }
        }

        parent::__construct($files,$path);
    }
}