<?php

namespace Txd\Core\CrudRenderers;

use Request;
use Route;
use Txd\Contracts\CrudRenderer;

class BaseCrudRenderer implements CrudRenderer {
    public array $custom_view_param = [];
    public $modelDisplayName = "Model";
    public ?string $route_base_name = null;
    public bool $edit_mode = true;
    public function __construct(Request $request,Route $route){
        
    }
    
    public function index($grid,$filters = null) {
        $info = compact("grid","filters");
        return view('txd::crud.index', array_merge($info, $this->custom_view_param));
    }

    public function show($model) {
        $this->edit_mode = false;
        return $this->edit($model);
    }

    public function create($model) {
        $model->id = 0;
        $next = $this->edit($model);
        $next->getData()["formUrl"] = route($this->route_base_name.".store");
		return $next;
    }
    
    public function edit($model) {
        $info = [
			"model"=>$model,
			"formUrl"=> route($this->route_base_name.".update",[$model->getKey()])
		];
		return view("txd::crud.edit", array_merge($info, $this->custom_view_param));
    }

    public function update($model)
    {
        return redirect(route($this->route_base_name.".show",[$model->getKey()]));
    }

    public function store($model)
    {
        return $this->update($model);
    }

    public function destroy($model)
    {
        return redirect(route($this->route_base_name.".index"));
    }

    public function error($model,$error) {
        $target = $model->exists? "edit":"create";
        return redirect(route($this->route_base_name.".$target",[$model->getKey()]))
				->withErrors($model->getErrors())
				->withInput();   
    }
}