<?php

namespace Txd\Settings\Drivers;

use InvalidArgumentException;
use Serializable;

class Database implements Driver {
    protected string $table;

    public function __construct($options = []){
        $this->table = $options['table_name'] ?? null;
        if(is_null($this->table)){
            throw new InvalidArgumentException("Required option 'table_name' is missing");
        }
    }

    protected function table() : \Illuminate\Database\Query\Builder {
        return \Illuminate\Support\Facades\DB::table($this->table);
    }

    public function set(string $key, $value,string $group = "default",bool $replace = false) :void {
        $value = json_encode($value);
        if($replace){
            $this->table()->updateOrInsert(['key'=>$key,'group'=>$group,'active'=>true],['value'=>$value]);
            return;
        }
        $this->table()->where('key',$key)->where('group',$group)->where('value',"!=",$value)->update(['active'=>false]);
        $this->table()->updateOrInsert(['key'=>$key,'group'=>$group,'value'=>$value],['active'=>true]);
        return;
    }

    public function get(string $key, string $group = "default") : mixed {
        $object = $this->table()->where('key',$key)->where('group',$group)->where('active',true)->first('value');
        return json_decode($object?->value ?? "null",true);
    }

    public function list(string $key, string $group = "default") : \Illuminate\Support\Collection {
        return $this->table()->where('key',$key)->where('group',$group)->orderBy('active')->get();
    }

    public function enable(string $key, $value, string $group = "default") :bool {
        $value = json_encode($value);
        $count = $this->table()->where('key',$key)->where('group',$group)->where('value',$value)->update(['active'=>true]);
        $success = $count>0;
        if($success){
            $this->table()->where('key',$key)->where('group',$group)->whereNot('value',$value)->update(['active'=>false]);
        }

        return $success;
    }

    public function disable(string $key, $value = null, string $group = "default") :bool {
        $value = json_encode($value);
        $count = $this->table()->where('key',$key)->where('group',$group)
            ->when(!is_null($value),fn($query) => $query->where('value',$value))
            ->update(['active'=>false]);
        return $count>0;
    }
}