<?php

if(!function_exists("settings")){
	function settings($driver = null){
		return app('settings')->driver($driver);
	}	
}


if (! function_exists('stampa')) {   
    function stampa(string $testo, bool $really_print = true,bool $js_available = false, string|null $fixed_lang = null)
    {
        return trans($testo,[],$fixed_lang);
    }
}

if(!function_exists("localUniqueString")){
	global $localUniqueStringHistory;
    $localUniqueStringHistory = [];
    /**
     * genera una stringa random garantita per la chiamata corrente
     * 
     * @return string
	 * 
     */
	function localUniqueString($prefix=null,$length=10) {
		global $localUniqueStringHistory;
		$string = $prefix.bin2hex(random_bytes($length));
		while(array_key_exists($string,$localUniqueStringHistory)) {
			$string = $prefix.bin2hex(random_bytes($length));
		}
		$localUniqueStringHistory[$string] = null;

		return $string;
	}
}

if(!function_exists("optionSelectHelper")){
	function optionSelectHelper($query,$etichetta, $valore,$allow_empty = true)
    {
        $etichettaIsMethod = Str::endsWith($etichetta,"()");
        if($etichettaIsMethod){
            $etichetta = substr($etichetta,0,strlen($etichetta)-2);
        }
        $valoreIsMethod = Str::endsWith($valore,"()");
        if($valoreIsMethod){
            $valore = substr($valore,0,strlen($valore)-2);
        }
		 
        $out = $query->applicaPermessi()->get()->reduce(function($carry,$el) use ($etichetta,$valore,$valoreIsMethod,$etichettaIsMethod){
            $carry[$valoreIsMethod?$el->{$valore}():$el->$valore] = $etichettaIsMethod?$el->{$etichetta}():$el->$etichetta;
            return $carry;
        },[]);

        return $allow_empty ? ([""=>"--"]+$out):$out;
    }
}

if(!function_exists("converto_query_param_to_string")){
	function converto_query_param_to_string($param) {
		$out = null;
		if(is_array($param)){
			$out = json_encode($param);
		}elseif(is_a($param, DateTime::class)){
			$out = $param->format("Y-m-d H:i:s");
		}else{
			try {
				$out = (string)$param;
			} catch (\Throwable $th) {
				$out = json_encode($param);
			}
		}
		return $out;
	}
}

if(!function_exists("debug_query_from_scratch")){
	function debug_query_from_scratch($sql, $dati){

		if(isset($dati) && $dati !== null && count($dati) > 0){

			if(strpos($sql, "?") !== false){

				//sostituiamo i ? in ordine
				foreach($dati as $value){
					$sql = preg_replace("/\?/", "'".converto_query_param_to_string($value)."'", $sql, 1);
				}
			}else{
				foreach($dati as $key => $value){
					$sql = str_replace(":".$key, "'".converto_query_param_to_string($value)."'", $sql);
				}
			}
		}

		return $sql;
	}
}


if(!function_exists("debug_query")){

	function debug_query($query_builder){

		if(!is_a($query_builder,"Illuminate\Database\Eloquent\Builder") && !is_a($query_builder,"Illuminate\Database\Query\Builder")){
			echo "<p>L'oggetto passato non e' del tipo corretto!"
			."<p>Tipo atteso: <b>Illuminate\Database\Eloquent\Builder</b>"
			."<br />Tipo ricevuto: <b>".get_class($query_builder)."</b>"
			."<p>Puo' essere che sia stato invocato il metodo ->get() prima di passare la \"query\" al metodo di debug";
			die();
		}

		try{
			// \DB::connection()->enableQueryLog();
			// \DB::connection()->flushQueryLog();

			// $query_builder->get();
			// $sql = \DB::getQueryLog()[0]["query"];
			// $dati = \DB::getQueryLog()[0]["bindings"];

			$sql = $query_builder->toSql();
			$dati = $query_builder->getBindings();

			$sql = debug_query_from_scratch($sql, $dati);

			$sql = "<pre style='white-space: pre-wrap;'>".$sql."</pre>";
			
			// \DB::connection()->disableQueryLog();
			// dump(\DB::getQueryLog());
			// \DB::connection()->flushQueryLog();

		}catch(\Exception $e){

			$sql = "<p>Siamo qui perch&eacute; la query presenta un errore e quindi non pu&ograve; essere esguito il binding automatico</p>";

			$sql .= "<p><b>Query:</b><pre style='white-space: pre-wrap;'>".$query_builder->toSql()."</pre>";

			$sql .= "<p><b>Bindings:</b> <pre style='white-space: pre-wrap;'>";
			$sql .= json_encode($query_builder->getBindings());
			$sql .= "</pre>";

			$sql .= "<p><b>Eccezione:</b> <pre style='white-space: pre-wrap;'>";
			$sql .= $e->getMessage();
			$sql .= "</pre>";
		}

		return $sql;
	}

}


if(!function_exists("inspect_query_stack")){

	/**
	 * ritorna una collection con tutte le query eseguite da quando e' stato attivato il query logger, raggruppate per query, ordinate per tempo (globale) di esecuzione
	 * 
	 * per funzionare deve essere abilitato il queryLogger, o attivando il middleware automatico, altrimenti usando \DB::connection()->enableQueryLog(); prima dell'esecuzione delle query da ispezionare
	 *
	 * @return \Illuminate\Support\Collection
	 */
	function inspect_query_stack(): \Illuminate\Support\Collection {
		return collect(\DB::getQueryLog())->groupBy("query")->map(function($el){
			$n = $el->count();
			$time = $el->sum("time");
			return [
				"n" => $n,
				"time"=>$time,
				"avg"=>$time/$n,
				"queries" => $el->map(function($subEl){ return debug_query_from_scratch($subEl["query"], $subEl["bindings"]); })
			];
		})->sortByDesc("time");
	}
}


if(!function_exists("isHttpsEnvUrl")){
    
    /**
     * verifica se l'url impostato nel file .env e' in https o meno
     * in questo modo potremo andare a generare a mano gli url opportuni nel caso in cui ci sia di mezzo un proxy o qualcosa di simile
     * per cui l'url automatico sarebbe in http
     * 
     * @return bool
	 * 
     */
	function isHttpsEnvUrl() {
		return \Illuminate\Support\Str::startsWith(config('app.url'), 'https://');
	}
}

if (!function_exists("context_error_details")) {

	/**
	 * ritorna un array o una stringa con alcune info utili per il debug
	 *
	 * @param bool $json_encoded [default FALSE] se impostato a TRUE ritorna una stringa json_econded, altrimenti un array
	 * @return string|array
	 */
	function context_error_details($json_encoded = false) {
		$out = [];
		try {
            $out = array_filter([
                'url' => request()->fullUrl(),
                'input' => request()->except(['password', 'password_confirmation']),
                'userId' => auth()->id(),
                'email' => auth()->user() ? auth()->user()->email : null,
                'ip' => request()->ip(),
            ]);
        } catch (\Throwable $e) {
            $out = [];
        }

		if($json_encoded){
			return json_encode($out);
		}else{
			return $out;
		}
	}
}

if(!function_exists("buildSlashPath")){
	/**
	 * riceve una serie di stringhe come parametri e ritorna la versione concatenata con un solo "/" tra ogni parte
	 *
	 * @param string $baseurl stringa di partenza
	 * @param string ...$parts elenco di parti da concatenare
	 * @return string
	 */
	function buildSlashPath(string $baseurl, string ...$parts): string {

		$baseurl = rtrim($baseurl, "/");
		array_walk($parts, function(&$part){
			$part = trim($part, "/");
		});

		return $baseurl."/".join("/", $parts);
	}
}
