<?php

namespace Txd\Translation;


use Txd\Translation\CachedFileLoader;

class TranslationServiceProvider extends \Illuminate\Translation\TranslationServiceProvider {

	public function boot(){
		
	}

	protected function registerLoader(){
		if(config("translation-manager.automatic_generation_from_db",true)){
			$this->app->singleton('translation.loader', function ($app) {
				return new CachedFileLoader($app['files'], $app['path.lang']);
			});
		}
		else{
			parent::registerLoader();
		}
	}

	protected function registerTranslator(){
		$this->app->singleton('translator', function($app)
        {
            $loader = $app['translation.loader'];

            // When registering the translator component, we'll need to set the default
            // locale as well as the fallback locale. So, we'll grab the application
            // configuration so we can easily get both of these values from there.
            $locale = $app['config']['app.locale'];
			
            $trans = new Translator($loader, $locale);

            $trans->setFallback($app['config']['app.fallback_locale']);

            if($app->bound('translation-manager')){
                $trans->setTranslationManager($app['translation-manager']);
            }

            return $trans;
        });
	}

	protected function registerCommand(){
		$this->app->singleton('command.txd-translation.cache', function ($app) {
            return new Console\RenewTranslationCacheCommand();
        });
        $this->commands('command.txd-translation.cache');
	}

	public function register(){
		$this->registerCommand();
		if($this->app['config']['translation-manager.listen'] ?? false){
			$this->registerLoader();
			$this->registerTranslator();	
		}else{
			parent::register();
		}
		
	}
}
