<?php

namespace Txd\Settings\Drivers;

class Config implements Driver
{
    protected string $node;

    public function __construct($options = [])
    {
        $this->node = $options['config_main_node'] ?? null;

    }

    protected function node($key, $group): string
    {
        return $key ? "$this->node.$group.$key" : "$this->node.$group";
    }

    public function set(string $key, $value, string $group = 'default', bool $replace = false): void
    {
        $value = json_encode($value);
        config()->set($this->node($key, $group), $value);

    }

    public function get(string $key, string $group = 'default'): mixed
    {
        $object = config()->get($this->node($key, $group));

        return json_decode($object ?? 'null', true);
    }

    public function list(string $key, string $group = 'default'): \Illuminate\Support\Collection
    {
        return collect(config()->get($this->node(null, $group)))->map(fn ($el) => json_decode($el ?? 'null', true));
    }

    public function enable(string $key, $value, string $group = 'default'): bool
    {
        $value = json_encode($value);
        config()->set($this->node($key, $group), $value);

        return true;
    }

    public function disable(string $key, $value = null, string $group = 'default'): bool
    {
        $value = json_encode($value);
        config()->set($this->node($key, $group), $value);

        return true;
    }
}
