<?php

namespace Txd\Core;

use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Foundation\AliasLoader;
use Illuminate\Support\ServiceProvider;
use Txd\Core\CrudRenderers\BaseCrudRenderer;
use Txd\Middleware\LocalDevOnly;

/**
 *  *
 * @author Fabio Spadea <fabio@techseed.it>
 */
class TxdCoreServiceProvider extends ServiceProvider
{
    /**
     * Boot the service provider.
     *
     * @return void
     */
    public function boot()
    {
        //caricamento namespace per view
        $this->loadViewsFrom(base_path('resources/views/vendor/txd'), 'txd');
        $this->loadViewsFrom(__DIR__.'/../resources/views', 'txd');

        $this->publishes([
            __DIR__.'/../resources/views' => resource_path('views/vendor/txd'),
        ]);

        Relation::macro('optionSelect', function () {
            return optionSelectHelper($this, ...func_get_args());
        });

        \Route::group(['middleware' => 'web'], function () {
            require __DIR__.'/../routes/web.php';
        });

        app('router')->aliasMiddleware('local_dev_only', LocalDevOnly::class);
        if (config('translation-manager.automatic_generation_from_db', true)) {
            \Barryvdh\TranslationManager\Models\Translation::saved(function () {
                $command = new \Txd\Translation\Console\RenewTranslationCacheCommand;
                $command->handle();
            });
        }
    }

    public function register()
    {
        $this->app->booting(function () {
            $loader = AliasLoader::getInstance();
            $loader->alias('crud_renderer', BaseCrudRenderer::class);
        });

    }

    public function bootCarbonExtensions() {}
}
