<?php

namespace Txd\Traits;

trait ShiftableArgumentsTrait
{
    public $shift_crud_args = 0;

    public $shiftable_methods = ['create', 'show', 'edit', 'destroy'];

    public $request_shiftable_methods = ['store', 'update'];

    public $shifted_parameters = [];

    public function callAction($method, $parameters)
    {
        if ($this->shift_crud_args > 0) {
            if (in_array($method, $this->shiftable_methods)) {
                $this->shifted_parameters = array_splice($parameters, 0, $this->shift_crud_args);
            }
            if (in_array($method, $this->request_shiftable_methods)) {
                $this->shifted_parameters = array_splice($parameters, 1, $this->shift_crud_args);
            }
            $this->shift_crud_args = 0;
        }

        return parent::callAction($method, $parameters);
    }
}
