<?php

namespace Txd\Traits;

use Illuminate\Support\Collection;
use Txd\Contracts\CrudRenderer;
use Txd\Core\RouteParameterMapping;

trait ResourceControllerTrait
{
    protected $edit_mode = null;

    public function renderer()
    {
        $this->initRenderer();

        return $this->renderer;
    }

    protected $existing_obj = null;

    protected function initialize()
    {
        $this->initModelName();
        $this->initRouteBaseName();
        $this->initModal();
        $this->initRenderer();
        $this->initParametersMapping();
        $this->initAuthorizeMethods();

    }

    protected function guessClassFromControllerName(): string
    {
        return str_replace('Controller', '', basename(str_replace('\\', '/', get_class($this))));
    }

    protected $model_name = null;

    protected function initModelName(?string $baseName = null)
    {
        if (is_null($this->model_name)) {
            $this->model_name = $baseName ?? "App\Models\\".$this->guessClassFromControllerName();
        }
    }

    protected $route_base_name = null;

    protected $route_parameter_name = null;

    protected function initRouteBaseName(?string $routeBaseName = null)
    {
        if (is_null($this->route_base_name)) {
            $this->initModelName();
            $currentRouteName = 'controller.executed.in.console';

            if (is_null($routeBaseName) && !is_null(\Illuminate\Support\Facades\Route::current())) {
                $currentRouteName = \Illuminate\Support\Facades\Route::current()->getName();
                $currentRouteName = substr($currentRouteName, 0, strrpos($currentRouteName, '.'));
            }
            $this->route_base_name = $routeBaseName ?? $currentRouteName;
            $pointPos = strrpos($this->route_base_name, '.');
            $this->route_parameter_name = $this->route_base_name;
            if ($pointPos !== false) {
                $this->route_parameter_name = substr($this->route_base_name, $pointPos + 1);
            }

            if ($this->route_parameter_name === 'console') {
                $this->route_parameter_name = null;
            }

        }
    }

    /**
     * Do not use.  Use ->modal() and ->setModal(bool)
     *
     * @internal
     */
    protected $modal = null;

    protected function initModal(?bool $modal = null)
    {
        if (is_null($this->modal)) {
            $this->modal = $modal ?? request()->ajax();
        }
    }

    protected function modal()
    {
        return optional($this->renderer())->modal ?? $this->modal;
    }

    protected function setModal(bool $state)
    {
        $this->modal = $state;
        if ($this->renderer()) {
            $this->renderer()->modal = $state;
        }
    }

    /**
     * Do not use.  Use ->modalShow() and ->setModalShow(bool)
     *
     * @internal
     */
    protected $modalShow = null;

    /**
     * Do not use.  Use ->modalCreate() and ->setModalCreate(bool)
     *
     * @internal
     */
    protected $modalCreate = null;

    /**
     * Do not use.  Use ->modalEdit() and ->setModalEdit(bool)
     *
     * @internal
     */
    protected $modalEdit = null;

    protected function setModalShow(bool $state)
    {
        $this->modalShow = $state;
        if ($this->renderer()) {
            $this->renderer()->modalShow = $state;
        }
    }

    protected function setModalCreate(bool $state)
    {
        $this->modalCreate = $state;
        if ($this->renderer()) {
            $this->renderer()->modalCreate = $state;
        }
    }

    protected function setModalEdit(bool $state)
    {
        $this->modalEdit = $state;
        if ($this->renderer()) {
            $this->renderer()->modalEdit = $state;
        }
    }

    protected function modalShow()
    {
        return $this->modal() || (optional($this->renderer())->modalShow ?? $this->modalShow);
    }

    protected function modalCreate()
    {
        return $this->modal() || (optional($this->renderer())->modalCreate ?? $this->modalCreate);
    }

    protected function modalEdit()
    {
        return $this->modal() || (optional($this->renderer())->modalEdit ?? $this->modalEdit);
    }

    protected ?CrudRenderer $renderer = null;

    protected function initRenderer(?string $rendererClass = null)
    {
        if (is_null($this->renderer)) {
            $this->initModelName();
            $this->initRouteBaseName();
            $this->initModal();
            $this->renderer = app()->make($rendererClass ?? 'crud_renderer');
            $this->renderer()->modal = $this->modal;
            $this->renderer()->route_base_name = $this->route_base_name;
            $this->renderer()->setModelDisplayNameFromClass($this->model_name);
        }
    }

    protected ?Collection $methodParametersMapping = null;

    protected $mainParameterName = null;

    protected function initParametersMapping(RouteParameterMapping ...$mappings)
    {
        if (is_null($this->methodParametersMapping)) {
            $this->initModelName();
            $this->mainParameterName = \Illuminate\Support\Str::camel(str_replace('App\\Models\\', '', $this->model_name));
            $mappingCollection = new Collection([
                new RouteParameterMapping('model', $this->model_name, $this->route_parameter_name),
                new RouteParameterMapping($this->mainParameterName, $this->model_name, $this->route_parameter_name),
            ]);
            $mappingCollection = $mappingCollection->keyBy('variableName')->merge(collect($mappings)->keyBy('variableName'));
            $this->methodParametersMapping = $mappingCollection;
        }
    }

    /**
     * @return Collection<RouteParameterMapping>
     */
    public function getParametersMapping(): Collection
    {
        $this->initParametersMapping();

        return $this->methodParametersMapping;
    }

    protected $authorizeMethods = null;

    protected function initAuthorizeMethods(bool $autorize = true)
    {
        if (is_null($this->authorizeMethods)) {
            $this->authorizeMethods = $autorize;
            if ($this->authorizeMethods) {
                $this->initModelName();
                $this->initParametersMapping();
                $this->authorizeResource($this->model_name, $this->route_parameter_name);
            }
        }
    }
}
