<?php

namespace Txd\Traits;

use Illuminate\Support\Facades\Schema;

trait OptionSelectTrait
{
    /**
     * genera automaticamente l'elenco delle option di un menu a tendina
     *
     * @param  string  $nome  il campo di cui stampare il valore;<br />
     *                        puo' essere: il nome di un campo del modello corrente; una relazione getRelazione.nome_campo; un metodo get_nome()
     * @param  type  $valore
     * @param  type  $campo_ordine
     * @param  type  $allow_empty
     * @param  ?string  $metodo_filtro
     * @param  type  $opzioni_filtro
     * @param  array  $additional_options  array con opzioni aggiuntive (as esempio il metodo per collegare le tendine)
     * @return type
     *
     * @throws \Exception
     */
    public static function option_select($nome, $valore, $campo_ordine = '', $allow_empty = true, $metodo_filtro = null, $opzioni_filtro = [], $additional_options = [])
    {

        if (!is_array($additional_options)) {
            $additional_options = [];
        }

        $relazione = $additional_options['relazione'] ?? null; // nome della colonna con il riferimento all'id della tenedina padre, la cui variazione determina quali elementi mostrare di questa entita'
        $with_trashed = $additional_options['with_trashed'] ?? false;

        $result = [];
        if ($allow_empty) {
            $result[''] = '--';
        }

        $table_name = with(new static)->getTable();
        $custom_sort = true;
        $tipo_ordinamento = 'ASC';

        // andiamo a vedere se c'e' anche un'indicazione di come ordinare i campi
        if (strlen($campo_ordine) > 0 && strpos($campo_ordine, '|') !== false) {
            $el_ordine = explode('|', $campo_ordine);

            $campo_ordine = trim($el_ordine[0]);

            $ordinamento_plausibile = strtoupper(trim($el_ordine[1]));
            if ($ordinamento_plausibile == 'ASC' || $ordinamento_plausibile == 'DESC') {
                $tipo_ordinamento = $ordinamento_plausibile;
            }

        }

        if (strlen($campo_ordine) == 0 || !in_array($campo_ordine, Schema::getColumnListing($table_name))) {
            $campo_ordine = Schema::getColumnListing($table_name)[0];
            $custom_sort = false;
        }

        //		foreach(self::orderBy($campo_ordine)->get() as $value){
        //			$result[$value->$valore] = $value->$nome;
        //		}

        $obj = self::orderBy($campo_ordine, $tipo_ordinamento);

        if ($with_trashed) {
            $obj->withTrashed();
        }
        //		self::applica_permessi($obj);

        $nome_classe = get_called_class(); // in questo modo recuperiamo l'istanza della classe figlia
        $nome_classe::applica_permessi($obj);

        if (!is_null($metodo_filtro) && method_exists($nome_classe, $metodo_filtro)) {
            $nome_classe::$metodo_filtro($obj, $opzioni_filtro);
        }

        $is_metodo = false;
        if (!is_null($nome) && strpos($nome, '()') !== false) {
            $is_metodo = true;
            $nome = str_replace('()', '', $nome);
        }

        $is_metodo_relazione = false;
        if (!is_null($relazione) && strpos($relazione, '()') !== false) {
            $is_metodo_relazione = true;
            $relazione = str_replace('()', '', $relazione);
        }

        //		echo debug_query($obj);
        //		die();

        if ($relazione === null) { // se non abbiamo specificato una relazione, gestiamo l'array in modo standard chiave => valore

            foreach ($obj->get() as $value) {
                if ($is_metodo) {
                    $result[$value->$valore] = $value->{$nome}();
                } else {
                    $result[$value->$valore] = $value->{$nome};
                }
            }

            if (!$custom_sort) {
                asort($result);
            }

        } else {

            foreach ($obj->get() as $value) {

                if ($is_metodo_relazione) {
                    $data_rif = ($value->{$relazione}() ?? 'ALL');
                } else {
                    $data_rif = ($value->{$relazione} ?? 'ALL');
                }

                if ($is_metodo) {
                    $result[$value->$valore] = [
                        'option_value' => $value->{$nome}(),
                        'data-rif' => $data_rif,
                    ];
                } else {
                    $result[$value->$valore] = [
                        'option_value' => $value->{$nome},
                        'data-rif' => $data_rif,
                    ];
                }
            }

        }

        return $result;
    }

    public static function option_select_si_no($allow_empty = true)
    {

        $result = [];
        if ($allow_empty) {
            $result[''] = '--';
        }

        $result[0] = 'No';
        $result[1] = 'Sì';

        return $result;
    }

    public function scopeOptionSelect($query, $etichetta, $valore, $allow_empty = true, $closure = true)
    {
        if ($closure) {
            return fn () => optionSelectHelper($query, $etichetta, $valore, $allow_empty);
        }

        return optionSelectHelper($query, $etichetta, $valore, $allow_empty);
    }
}
