<?php

namespace Txd\Carbon;

use Carbon\Carbon;
use Carbon\Exceptions\InvalidFormatException;
use Illuminate\Support\ServiceProvider;

class CarbonServiceProvider extends ServiceProvider
{
    public function boot()
    {
        $CarbonDateMap = [];
        Carbon::macro('isDatetime', function ($value = null) use ($CarbonDateMap) {
            $index = spl_object_hash($this);
            if (is_null($value)) {
                $found = $CarbonDateMap[$index] ?? true;

                return !$found;
            }
            if ($value) {
                unset($CarbonDateMap[$index]);
            } else {
                $CarbonDateMap[$index] = true;
            }
        });
        $CarbonInvalidMap = [];
        Carbon::macro('isInvalid', function ($value = null) use ($CarbonInvalidMap) {
            $index = spl_object_hash($this);
            if (is_null($value)) {
                $found = $CarbonInvalidMap[$index] ?? true;

                return !$found;
            }
            if ($value) {
                unset($CarbonInvalidMap[$index]);
            } else {
                $CarbonInvalidMap[$index] = true;
            }
        });

        $CarbonRawMap = [];
        Carbon::macro('raw', function ($value = null) use ($CarbonRawMap) {
            $index = spl_object_hash($this);
            if (is_null($value)) {
                $found = $CarbonRawMap[$index] ?? true;

                return !$found;
            }
            $CarbonRawMap[$index] = $value;
        });

        Carbon::macro('print_data', function ($format = null) {
            return $this->formatWithDefault($format);
        });

        Carbon::macro('formatWithDefault', function ($format = null) {
            if ($this->isInvalid()) {
                return $this->raw();
            }
            if ($format === null) {
                $format = config('par.date_format', 'd/m/Y');
                if ($this->isDatetime()) {
                    $format = config('par.datetime_format', $format);
                }
            }

            return $this->format($format);
        });

        Carbon::macro('parseWithDefault', function ($time = null, $tz = null) {
            $formats = ['d/m/Y', 'd/m/Y H:i:s'];
            foreach ($formats as $format) {
                try {
                    $carbonDate = Carbon::createFromFormat($format, $time, $tz);
                    if ($carbonDate->getLastErrors()['warning_count'] > 0 || $carbonDate->getLastErrors()['error_count'] > 0) {
                        throw new InvalidFormatException('');
                    }
                    if (strlen($time) === 10) {
                        $carbonDate->isDatetime = false;
                        $carbonDate->setTime(0, 0, 0, 0);
                    }

                    return $carbonDate;
                } catch (InvalidFormatException $e) {

                }
            }
            try {

                return Carbon::parse($time, $tz);
            } catch (\Throwable $e) {
                $invalidCarbon = new Carbon;
                $invalidCarbon->isInvalid(true);
                $invalidCarbon->raw($time);

                return $invalidCarbon;
            }
        });

        Carbon::macro('stampa_data', function ($data, $options = []) {
            $format = (isset($options['format']) ? $options['format'] : null);
            $escape = (isset($options['escape']) ? $options['escape'] : '');

            if (is_a($data, Carbon::class)) {
                return $data->formatWithDefault($format);
            }

            if (is_a($data, 'DateTime')) {
                $data = $data->formatWithDefault('Y-m-d H:i:s');
            }

            if (strlen($data ?? '') == 0) {
                return '';
            }

            if ($data == $escape) {
                return '';
            }

            $data_obj = Carbon::parseWithDefault($data);

            return $data_obj->formatWithDefault($format);
        });

    }
}
