<?php

namespace Txd\Core\Policies;

use Illuminate\Auth\Access\HandlesAuthorization;

class BasePolicy
{
    use HandlesAuthorization;

    public function before($user, $ability)
    {

        if ($user->isAdmin()) {
            // return true;
        }

    }

    public function viewAny($user)
    {
        return true;
    }

    /**
     * Determine whether the user can view the settings.
     *

     * @return mixed
     */
    public function view($user, $model_obj)
    {
        $query = $model_obj->newQuery()->select($model_obj->getKeyName());
        $query->where($model_obj->getKeyName(), $model_obj->getKey());

        $model_obj::applica_permessi($query, $user);

        return $query->count() > 0;
    }

    /**
     * Determine whether the user can create settings.
     *
     * @return mixed
     */
    public function create($user)
    {
        return $this->viewAny($user);
    }

    /**
     * Determine whether the user can update the settings.
     *
     * @param  App\Settings  $model_obj
     * @return mixed
     */
    public function update($user, $model_obj)
    {

        return $this->view($user, $model_obj);
    }

    /**
     * Determine whether the user can delete the settings.
     *
     * @param  App\Settings  $model_obj
     * @return mixed
     */
    public function delete($user, $model_obj)
    {
        return $this->update($user, $model_obj);
    }
}
