<?php

namespace Txd\Core;

use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Foundation\AliasLoader;
use Illuminate\Support\ServiceProvider;
use Txd\Middleware\LocalDevOnly;
use Txd\Translations\TranslationServiceProvider;

/**
 *  *
 * @author Fabio Spadea <fabio@techseed.it>
 */
class TxdCoreServiceProvider extends ServiceProvider
{
    /**
     * Boot the service provider.
     *
     * @return void
     */
    public function boot()
    {

        Relation::macro('optionSelect', function () {
            return optionSelectHelper($this, ...func_get_args());
        });

        \Route::group(['middleware' => 'web'], function () {
            require __DIR__.'/../routes/web.php';
        });

        app('router')->aliasMiddleware('local_dev_only', LocalDevOnly::class);

        AliasLoader::getInstance([
            'Txd\Translation\TranslationServiceProvider' => TranslationServiceProvider::class,
        ]);
    }

    public function register() {}

    public function bootCarbonExtensions() {}
}
