<?php

namespace Txd\Log;

class TxdLogContextExtension
{
    protected array $contextExtension = [];

    public function addContextDetail(string $key, mixed $value, bool $push = false): self
    {
        if ($push && isset($this->contextExtension[$key]) && is_array($this->contextExtension[$key])) {
            $this->contextExtension[$key][] = $value;

            return $this;
        }

        $this->contextExtension[$key] = $push ? [$value] : $value;

        return $this;
    }

    public function toArray(): array
    {
        return $this->contextExtension;
    }
}
