<?php

namespace JSM\Base;

use Illuminate\Support\ServiceProvider;

class jsmServiceProvider extends ServiceProvider{

	/**
	 * Bootstrap the application services.
	 *
	 * @return void
	 */
	public function boot(){

//        $this->publishes([
//			__DIR__.'/JSM' => base_path('app/JSM'),
//		], "jsm");

		$this->publishes([
			__DIR__.'/Mail' => base_path('app/Mail'),
		], "mail");

		$this->publishes([
			__DIR__.'/views' => base_path('resources/views'),
		], "views");

		$this->publishes([
			__DIR__.'/Policies' => base_path('app/Policies'),
		], "policies");
		
		$this->publishes([
			__DIR__.'/config/jsm_log.php' => config_path('jsm_log.php'),
		], "log");
		
		
		$this->publishes([
			__DIR__.'/config/jsm_tables_names.php' => config_path('jsm_tables_names.php'),
		], "jsm_tables_names");


		$this->loadMigrationsFrom(__DIR__.'/Migrations');
		
		
		$this->mergeConfigFrom(
			__DIR__.'/config/jsm_log.php', 'jsm_log'
		);
		
		$this->mergeConfigFrom(
			__DIR__.'/config/jsm_tables_names.php', 'jsm_tables_names'
		);
		
		$this->mergeConfigFrom(
			__DIR__.'/config/jsm_maintenance.php', 'jsm_maintenance'
		);
		
		
//		$this->loadRoutesFrom(__DIR__.'/routes.php');


		\Route::group([
			'middleware' => 'web',
				//'namespace' => $this->namespace,
				], function ($router){
			require __DIR__.'/routes.php';
		});

		$this->app->make('JSM\Base\Controllers\jsmController');


		/*
		 * andiamo a registrare alcune estensioni del Validator
		 */
		\Validator::extend('date_nullable', function($attribute, $value, $parameters, $validator) {
			
			if($value === null){
				return true;
			}
			
            $tmp = \Validator::make([$attribute => $value], [$attribute => "date"]);
			return $tmp->passes();
        });

		\Validator::extend('numeric_nullable', function($attribute, $value, $parameters, $validator) {
			
			if($value === null){
				return true;
			}
			
            $tmp = \Validator::make([$attribute => $value], [$attribute => "numeric"]);
			return $tmp->passes();
        });
		
		\Validator::extend('integer_nullable', function($attribute, $value, $parameters, $validator) {
			
			if($value === null){
				return true;
			}
			
            $tmp = \Validator::make([$attribute => $value], [$attribute => "integer"]);
			return $tmp->passes();
        });

	}

	/**
	 * Register the application services.
	 *
	 * @return void
	 */
	public function register(){
//		include __DIR__.'/routes.php';
//		$this->app->make('JSM\Base\Controllers\jsmController');
		$this->app->make('JSM\Base\Controllers\MainController');
		
		try{
			$this->app['router']->aliasMiddleware('isAdmin', 'JSM\Base\Middleware\isAdmin');
			$this->app['router']->aliasMiddleware('checkGate', 'JSM\Base\Middleware\checkGate');
			$this->app['router']->aliasMiddleware('checkGate', 'JSM\Base\Middleware\CheckForMaintenanceMode');
		}catch(\BadMethodCallException $e){
			$this->app['router']->middleware('isAdmin', 'JSM\Base\Middleware\isAdmin');
			$this->app['router']->middleware('checkGate', 'JSM\Base\Middleware\checkGate');
			$this->app['router']->middleware('checkGate', 'JSM\Base\Middleware\CheckForMaintenanceMode');
		}catch(\Exception $e){
			die("jsmServiceProvider: middleware method not found!");
		}
	}

}
