<?php

namespace JSM\Base\JSM;

use Zofe\Rapyd\DataForm\DataForm;
use Zofe\Rapyd\DataForm\Field\Daterange;
use Zofe\Rapyd\Persistence;
use Zofe\Rapyd\Rapyd;
use Collective\Html\FormFacade as Form;
use Illuminate\Support\Facades\DB;


/**
 * estendiamo la classe Daterange per poter modificare il metodo build in modo da non andare in conflitto con la nuova versione di laravelcollective/html
 *
 * (a seguire estendiamo le varie classi collegate per poter risalire fino a qui)
 */
class jsmDateRange extends Daterange {
	
	public function build(){
		//riscriviamo il metodo per fixare il problema dell'array come input
//		parent::build();
		
		$output = "";

        unset($this->attributes['type']);
		
		$old_name = $this->name;
		$this->name = $this->name . '[from]';
		
        if (parent::build() === false) return;
        
		$this->name = $old_name;
		
        switch ($this->status) {

            case "show":
                if (!isset($this->value)) {
                    $value = $this->layout['null_label'];
                } else {
                    $value = str_replace($this->serialization_sep, ' ', $this->value);
                }
                $output = $value;
                $output = "<div class='help-block'>" . $output . "&nbsp;</div>";
                break;

            case "create":
            case "modify":


                Rapyd::css('datepicker/datepicker3.css');
                Rapyd::js('datepicker/bootstrap-datepicker.js');
                if ($this->language != "en") {
                    Rapyd::js('datepicker/locales/bootstrap-datepicker.' . $this->language . '.js');
                }

                unset($this->attributes['id']);
                //$this->attributes['class'] = "form-control";


                $from = Form::text($this->name . '[from]', @$this->values[0], $this->attributes);
                $to = Form::text($this->name . '[to]', @$this->values[1], $this->attributes);

                $output = '
                            <div id="range_' . $this->name . '_container">
                                <div class="input-daterange">
                                   <div class="input-group">
                                       <div class="input-group-addon">&ge;</div>
                                       ' . $from . '
                                   </div>
                                   <div class="input-group">
                                        <div class="input-group-addon">&le;</div>
                                        ' . $to . '
                                   </div>
                                </div>
                            </div>';

                Rapyd::pop_script();
                Rapyd::script("
                        $('#range_{$this->name}_container .input-daterange').datepicker({
                            format: '{$this->formatToDate()}',
                            language: '{$this->language}',
                            todayBtn: 'linked',
                            autoclose: true
                        });");

                break;
            case "hidden":
                $output = Form::hidden($this->name, $this->value);
                break;
            default:
                ;
        }
        $this->output = $output;
	}
	
}

class jsmDataForm extends DataForm{
	
	public function build($view = ''){
		parent::build($view);
	}
	
	public function buildFields(){
		parent::buildFields();
	}
	
}

class jsmDataFilter extends jsmDataForm
{

    public $cid;
    public $source;
    protected $process_url = '';
    protected $reset_url = '';
    public $attributes = array('class'=>'form-inline');
	
	public $custom_view = "layouts.jsmDataform_inline";
	public $custom_class = "";
	public $gruppi_filtri = array("zdefault" => array("class" => "col-xs-12", "label_style" => ""));

	public function get_gruppi_filtri(){
		ksort($this->gruppi_filtri);
		return $this->gruppi_filtri;
	}

	/**
     *
     * @var \Illuminate\Database\Query\Builder
     */
    public $query;

	public function build($view = ''){
		
		$view = $this->custom_view;
		
		parent::build($view);
	}
	
    /**
     * @param $source
     *
     * @return static
     */
    public static function source($source = null)
    {
        $ins = new static();
        $ins->source = $source;
        $ins->query = $source;
        if (is_object($source) && (is_a($source, "\Illuminate\Database\Eloquent\Builder") ||
                                  is_a($source, "\Illuminate\Database\Eloquent\Model"))) {
            $ins->model = $source->getModel();
        }
        $ins->cid = $ins->getIdentifier();
        $ins->sniffStatus();
        $ins->sniffAction();

        return $ins;
    }

    protected function table($table)
    {
        $this->query = DB::table($table);

        return $this->query;
    }

    protected function sniffAction()
    {

        $this->reset_url = $this->url->remove('ALL')->append('reset'.$this->cid, 1)->get();
        $this->process_url = $this->url->remove('ALL')->append('search'.$this->cid, 1)->get();

        ///// search /////
        if ($this->url->value('search')) {
            $this->action = "search";

            Persistence::save();
        }
        ///// reset /////
        elseif ($this->url->value("reset")) {
            $this->action = "reset";

            Persistence::clear();
        } else {

            Persistence::clear();
        }
    }

    protected function process()
    {
        $this->method = 'GET';

        //database save
        switch ($this->action) {
            case "search":

                // prepare the WHERE clause
                foreach ($this->fields as $field) {

                    $field->getValue();
                    $field->getNewValue();
                    $value = $field->new_value;

                    //query scope
                    $query_scope = $field->query_scope;
                    $query_scope_params = $field->query_scope_params;
                    if ($query_scope) {

                        if (is_a($query_scope, '\Closure')) {

                            array_unshift($query_scope_params, $value);
                            array_unshift($query_scope_params, $this->query);
                            $this->query = call_user_func_array($query_scope, $query_scope_params);

                        } elseif (isset($this->model) && method_exists($this->model, "scope".$query_scope)) {
                            
                            $query_scope = "scope".$query_scope;
                            array_unshift($query_scope_params, $value);
                            array_unshift($query_scope_params, $this->query);
                            $this->query = call_user_func_array([$this->model, $query_scope], $query_scope_params);
                            
                        } 
                        continue;
                    }

                    //detect if where should be deep (on relation)
                    $deep_where = false;

                    if (isset($this->model) && $field->relation != null) {
                        $rel_type = get_class($field->relation);

                        if (
                            is_a($field->relation, 'Illuminate\Database\Eloquent\Relations\HasOne')
                            || is_a($field->relation, 'Illuminate\Database\Eloquent\Relations\HasMany')
                            || is_a($field->relation, 'Illuminate\Database\Eloquent\Relations\BelongsTo')
                            || is_a($field->relation, 'Illuminate\Database\Eloquent\Relations\BelongsToMany')
                        ){
                            if (
                                is_a($field->relation, 'Illuminate\Database\Eloquent\Relations\BelongsTo') and
                                in_array($field->type, array('select', 'radiogroup', 'autocomplete'))
                            ){
                                    $deep_where = false;
                            } else {
                                $deep_where = true;
                            }

                        }
                    }
                    
                    if ($value != "" or (is_array($value)  and count($value)) ) {
                        if (strpos($field->name, "_copy") > 0) {
                            $name = substr($field->db_name, 0, strpos($field->db_name, "_copy"));
                        } else {
                            $name = $field->db_name;
                        }

                        //$value = $field->value;
                       
                        if ($deep_where) {
                            //exception for multiple value fields on BelongsToMany
                            if (
                                (is_a($field->relation, 'Illuminate\Database\Eloquent\Relations\BelongsToMany')
                                || is_a($field->relation, 'Illuminate\Database\Eloquent\Relations\BelongsTo')
                                ) and
                                in_array($field->type, array('tags','checks','multiselect'))
                            ){
                                  $values = explode($field->serialization_sep, $value);

                                  if ($field->clause == 'wherein') {
                                      $this->query = $this->query->whereHas($field->rel_name, function ($q) use ($field, $values) {
                                          $q->whereIn($field->rel_fq_key, $values);
                                      });
                                  }

                                  if ($field->clause == 'where') {
                                      foreach ($values as $v) {
                                          $this->query = $this->query->whereHas($field->rel_name, function ($q) use ($field, $v) {
                                              $q->where($field->rel_fq_key,'=', $v);
                                          });
                                      }
                                  }
                                continue;
                            }

                            switch ($field->clause) {
                                case "like":
                                    $this->query = $this->query->whereHas($field->rel_name, function ($q) use ($field, $value) {
                                        $q->where($field->rel_field, 'LIKE', '%' . $value . '%');
                                    });
                                    break;
                                case "orlike":
                                    $this->query = $this->query->orWhereHas($field->rel_name, function ($q) use ($field, $value) {
                                        $q->where($field->rel_field, 'LIKE', '%' . $value . '%');
                                    });
                                    break;
                                case "where":
                                    $this->query = $this->query->whereHas($field->rel_name, function ($q) use ($field, $value) {
                                        $q->where($field->rel_field, $field->operator, $value);
                                    });
                                    break;
                                case "orwhere":
                                    $this->query = $this->query->orWhereHas($field->rel_name, function ($q) use ($field, $value) {
                                        $q->where($field->rel_field, $field->operator, $value);
                                    });
                                    break;
                                case "wherebetween":
                                    $values = explode($field->serialization_sep, $value);
                                    $this->query = $this->query->whereHas($field->rel_name, function ($q) use ($field, $values) {

                                        if ($values[0] != '' and $values[1] == '') {
                                            $q->where($field->rel_field, ">=", $values[0]);
                                        } elseif ($values[0] == '' and $values[1] != '') {
                                            $q->where($field->rel_field, "<=", $values[1]);
                                        } elseif ($values[0] != '' and $values[1] != '') {

                                            //we avoid "whereBetween" because a bug in laravel 4.1
                                            $q->where(
                                                function ($query) use ($field, $values) {
                                                    return $query->where($field->rel_field, ">=", $values[0])
                                                                 ->where($field->rel_field, "<=", $values[1]);
                                                }
                                            );
                                        }

                                    });
                                    break;
                                case "orwherebetween":
                                    $values = explode($field->serialization_sep, $value);
                                    $this->query = $this->query->orWhereHas($field->rel_name, function ($q) use ($field, $values) {

                                        if ($values[0] != '' and $values[1] == '') {
                                            $q->orWhere($field->rel_field, ">=", $values[0]);
                                        } elseif ($values[0] == '' and $values[1] != '') {
                                            $q->orWhere($field->rel_field, "<=", $values[1]);
                                        } elseif ($values[0] != '' and $values[1] != '') {

                                            //we avoid "whereBetween" because a bug in laravel 4.1
                                            $q->orWhere(
                                                function ($query) use ($field, $values) {
                                                    return $query->where($field->rel_field, ">=", $values[0])
                                                                 ->where($field->rel_field, "<=", $values[1]);
                                                }
                                            );
                                        }

                                    });
                                    break;
                            }

                        //not deep, where is on main entity
                        } else {

                            switch ($field->clause) {
                                case "like":
                                    $this->query = $this->query->where($name, 'LIKE', '%' . $value . '%');
                                    break;
                                case "orlike":
                                    $this->query = $this->query->orWhere($name, 'LIKE', '%' . $value . '%');
                                    break;
                                case "where":
                                    $this->query = $this->query->where($name, $field->operator, $value);
                                    break;
                                case "orwhere":
                                    $this->query = $this->query->orWhere($name, $field->operator, $value);
                                    break;
                                case "wherein":
                                    $this->query = $this->query->whereIn($name,  explode($field->serialization_sep, $value));
                                    break;
                                case "wherebetween":
                                    $values = explode($field->serialization_sep, $value);
                                    if (count($values)==2) {

										/* -----------------------------------------------------------------------------------------
										 * verifichiamo se i campi del between sono date o meno e nel caso aggiungiamo i minuti
										 */
										
										$is_data_start = false;
										$is_data_end = false;
										$data_partenza_string = $values[0];
										$data_fine_string = $values[1];
										
										
										if(strlen($values[0]) > 0){
											$is_data_start = \classe_data::check_dataTime($values[0], -1);
											
											if($is_data_start){
												$data_partenza = new \classe_data($values[0]);
												
												if(strlen($values[0]) == 10){
													$data_partenza_string = $data_partenza->print_data("Y-m-d")." 00:00:00";
												}else{
													$data_partenza_string = $data_partenza->print_data("Y-m-d H:i:s");
												}
											}
										}
										
										if(strlen($values[1]) > 0){
											$is_data_end = \classe_data::check_dataTime($values[1], -1);
											
											if($is_data_end){
												$data_fine = new \classe_data($values[1]);
												
												if(strlen($values[1]) == 10){
													$data_fine_string = $data_fine->print_data("Y-m-d")." 23:59:59";
												}else{
													$data_fine_string = $data_fine->print_data("Y-m-d H:i:s");
												}
											}
										}
										
										if($is_data_start){
											$values[0] = $data_partenza_string;
										}
										
										if($is_data_end){
											$values[1] = $data_fine_string;
										}
										
										/*
										 * fine aggiunta datetime
										 ------------------------------------------------------------------------------------------ */
										
                                        if ($values[0] != '' and $values[1] == '') {
                                            $this->query = $this->query->where($name, ">=", $values[0]);
                                        } elseif ($values[0] == '' and $values[1] != '') {
                                            $this->query = $this->query->where($name, "<=", $values[1]);
                                        } elseif ($values[0] != '' and $values[1] != '') {

                                            //we avoid "whereBetween" because a bug in laravel 4.1
                                            $this->query =  $this->query->where(
                                                function ($query) use ($name, $values) {
                                                     return $query->where($name, ">=", $values[0])
                                                                  ->where($name, "<=", $values[1]);
                                                }
                                            );

                                        }

                                    }

                                    break;
                                case "orwherebetween":
                                    $values = explode($field->serialization_sep, $value);
                                    if (count($values)==2) {
                                        if ($values[0] != '' and $values[1] == '') {
                                            $this->query = $this->query->orWhere($name, ">=", $values[0]);
                                        } elseif ($values[0] == '' and $values[1] != '') {
                                            $this->query = $this->query->orWhere($name, "<=", $values[1]);
                                        } elseif ($values[0] != '' and $values[1] != '') {
                                            //we avoid "whereBetween" because a bug in laravel 4.1
                                            $this->query =  $this->query->orWhere(
                                                function ($query) use ($name, $values) {
                                                    return $query->where($name, ">=", $values[0])
                                                                 ->where($name, "<=", $values[1]);
                                                }
                                            );
                                        }

                                    }

                                    break;
                            }
                        }

                    }
                }
                // dd($this->query->toSql());
                break;
            case "reset":
                $this->process_status = "show";

                return true;
                break;
            default:
                return false;
        }
    }

}
