<?php



class campi_form {
	
	public $nome_campo = "";
	public $etichetta = "";
	public $tipo_campo = "";
	public $obbligatorio = false;
	public $min_len = null;
	public $max_len = null;
	public $classi_html = array();
	public $placeholder = "";
	public $opzioni_select = array();
	public $valore_fisso = null;
	public $parse_function = "";
	public $parse_options = array();
	public $parse_options_view = array();
	public $classi_etichetta = array();
	public $is_checked = null;
	public $classe_box = "";
	public $custom_html = "";
	public $attributes = array();
	public $real_obj = null;  //se e' un oggetto e non viene passato nulla ai metodi print_view e print_input, viene utilizzato per la stampa dei valori
	public $default_options = array(); //se viene passato il suo equivalente nelle varie funzioni print, questo campo non viene utilizzato

	public static $bottoni_form = array(
					"salva" => array("etichetta" => "<i class='fa fa-save'></i> Salva", "classi" => "btn-primary edit_form_field"),
					"annulla" => array("etichetta" => "<i class='fa fa-times'></i> Annulla", "classi" => "btn-danger edit_form_field reset_form"),
					"modifica" => array("etichetta" => "<i class='fa fa-pencil'></i> Modifica", "classi" => "btn-info edit_form_js view_form_field"),
					"elenco" => array("etichetta" => "<i class='fa fa-list'></i> Torna all&apos;elenco", "classi" => "btn-warning", "link" => "#"),
				);


	public function __construct($nome, $tipo = "text", $obbligatorio = false, $classi_html = array(), $placeholder = "", $etichetta = "", $min_len = null, $max_len = null){
		
		$this->nome_campo = $nome;
		$this->etichetta = strlen($etichetta) > 0 ? $etichetta : ucwords(str_replace("_", " ", $nome));
		$this->tipo_campo = $tipo;
		$this->obbligatorio = is_bool($obbligatorio) ? $obbligatorio : false;
		$this->min_len = is_int($min_len) ? $min_len : null;
		$this->max_len = is_int($max_len) ? $min_len : null;
		$this->classi_html = is_array($classi_html) ? $classi_html : array();
		$this->placeholder = $placeholder;
		
	}
	
	
	public function tipo_campo_form(){
		
		$tipo_campo_form = "";
		
		switch($this->tipo_campo){
			
			case "text":
				$tipo_campo_form = "text";
				break;
			
			case "email":
				$tipo_campo_form = "email";
				break;
			
			case "password":
				$tipo_campo_form = "password";
				break;
			
			case "number":
				$tipo_campo_form = "number";
				break;
			
			case "select":
				$tipo_campo_form = "select";
				break;
			
			case "select_linked":
				$tipo_campo_form = "select_linked";
				break;
			
			case "checkbox":
				$tipo_campo_form = "checkbox";
				break;
			
			case "radio":
				$tipo_campo_form = "radio";
				break;
			
			case "textarea":
				$tipo_campo_form = "textarea";
				break;
			
			case "hidden":
				$tipo_campo_form = "hidden";
				break;

			case "custom_macro":
				$tipo_campo_form = "custom_macro";
				break;
				
			case "parse_value":
				$tipo_campo_form = "parse_value";
				break;
			
			case "file":
				$tipo_campo_form = "file";
				break;
			
			case "solo_testo":
				$tipo_campo_form = "solo_testo";
				break;
			
			case "html":
				$tipo_campo_form = "html";
				break;
				
			case "data":
				$tipo_campo_form = "parse_value";
				$this->parse_function = "stampa_data";
				break;
				
			case "datatime":
				$tipo_campo_form = "parse_value";
				$this->parse_function = "stampa_dataTime";
				break;
			
			case "valuta":
				$tipo_campo_form = "parse_value";
				$this->parse_function = "stampa_valuta";
				break;
				
			
			default:
				$tipo_campo_form = "text";
				break;
		}
		
		return $tipo_campo_form;
	}
	

	/**
	 * verifica se il campo in oggetto ha la regola "required" nel set di regole passate come parametro
	 * <br>oppure se e' stato instanziato con l'opzione obbligatorio a TRUE
	 * 
	 * @param array $rules array con le regole (lo stesso recuperato da $obj->getRules())
	 * @return boolean
	 */
	public function is_mandatory($rules = []){
		
		$tmp = new \Illuminate\Validation\ValidationRuleParser([]);
		$parsed_rules = json_decode(json_encode($tmp->explode($rules)), true);
		$parsed_rules_field = isset($parsed_rules["rules"][$this->nome_campo]) ? $parsed_rules["rules"][$this->nome_campo] : [];
		
		return (array_search("required", $parsed_rules_field) !== false || $this->obbligatorio);
	}


	/**
	 * ritorna l'html di una label per il campo in oggetto, eventualmente concatenando l'asterisco per i campi obbligatori
	 * 
	 * @param boolean $with_asterisk se TRUE controlla che il campo in oggetto abbia la regola "required" per l'oggetto passato
	 * @param objecy $extisting_obj necessario in caso di $with_asterisk == TRUE -> e' l'oggetto da cui recuperare l'elenco delle regole
	 * @param boolean $skip_label_class se impostato a TRUE inibisce la stampa delle clssi html "standard" della label (col-sm-3 control-label)
	 * @return string html da stampare nel blade
	 */
	public function print_label($with_asterisk = false, $extisting_obj = null, $skip_label_class = false){
		
		$asterisco = "";
		
		if($with_asterisk && is_object($extisting_obj) && method_exists($extisting_obj, "getRules")){
			
			if($this->is_mandatory($extisting_obj->getRules())){
				$asterisco = "<span class='edit_form_field'> *</span>";
			}
		}
		
		$label_class = "col-sm-3 control-label";
		if($skip_label_class){
			$label_class = "";
		}
		
		return \Form::label($this->nome_campo, $this->etichetta.$asterisco, ['class' => $label_class.' '.join(" ", $this->classi_etichetta)], false);
	}

	
	/**
	 * ritorna l'html del campo in oggetto per la modalita' edit, quindi input text, textarea, etc.
	 * 
	 * @param type $existing_obj
	 * @param array $options
	 * @return string html da stampare nel blade
	 * @throws Exception
	 */
	public function print_input_field($existing_obj = null, $options = null){

		//controlliamo se l'oggetto e' stato ricevuto direttamente o se dobbiamo aspettarcelo globale a livello di campo
		if(is_object($this->real_obj) && $existing_obj === null){
			$existing_obj = $this->real_obj;
		}
		
		//se nessuno dei due oggetti e' settato andiamo in eccezione
		if(!is_object($existing_obj)){
			throw new \Exception("Object Required in order to print input field!");
		}
		
		//diamo la possibilita' di definire le opzioni di stampa a livello globale di oggetto campo
		if(is_array($this->default_options) && is_array($options)){
			$options = array_merge($this->default_options, $options);
		}elseif(!is_array($options)){
			if(is_array($this->default_options)){
				$options = $this->default_options;
			}else{
				$options = [];
			}
		}

		$out = "";
		
		if(!is_array($options)){
			throw new Exception("options must be an array, ".gettype($options)." given");
		}
		
		$skip_enclosure = isset($options["skip_enclosure"])&&is_bool($options["skip_enclosure"]) ? $options["skip_enclosure"] : false;
		$input_error = isset($options["input_error"])&&is_bool($options["input_error"]) ? $options["input_error"] : true;
		$read_only = isset($options["read_only"])&&is_bool($options["read_only"]) ? $options["read_only"] : false;
		
		if($read_only){
			return "";
		}
		if(!$skip_enclosure){
			$out .= "<div class='edit_form_field eff_style'>";
		}
		
		if($input_error && \Session::has("errors") && \Session::get("errors")->has($this->nome_campo)){
			$this->classi_html[] = " input_rosso";
		}

		if($this->tipo_campo_form() == "password"){
			$out .= Form::{$this->tipo_campo_form()}($this->nome_campo, array_merge(['class' => 'form-control '.join(" ", $this->classi_html), 'placeholder' => $this->placeholder], $this->attributes));
			$out .= Form::{$this->tipo_campo_form()}($this->nome_campo."_confirmation", ['class' => 'form-control '.join(" ", $this->classi_html), 'placeholder' => $this->nome_campo." confirmation"]);
		}elseif($this->tipo_campo_form() == "file"){

			$out .= Form::{$this->tipo_campo_form()}($this->nome_campo, array_merge(['class' => 'form-control '.join(" ", $this->classi_html), 'placeholder' => $this->placeholder], $this->attributes));
			
		}elseif($this->tipo_campo_form() == "select_linked"){

			$out .= "<select name='".$this->nome_campo."' class='form-control ".join(" ", $this->classi_html)."'";
			
			foreach($this->attributes as $key => $value){
				$out .= " ".$key."='".$value."' ";
			}
			
			$out .= ">";
			
			foreach($this->opzioni_select as $key => $tmp){
				$out .= "<option data-rif='".($tmp["data-rif"] ?? "")."' value='".$key."' ".($existing_obj->{$this->nome_campo} == $key ? "selected" : "").">".
						(is_array($tmp) && isset($tmp["option_value"]) ? $tmp["option_value"] : (is_string($tmp)?$tmp:""))."</option>";
			}
			
			$out .= "</select>";
			
		}elseif($this->tipo_campo_form() == "select"){
			
			$out .= Form::{$this->tipo_campo_form()}($this->nome_campo, $this->opzioni_select, $this->valore_fisso, array_merge(['class' => 'form-control '.join(" ", $this->classi_html)], $this->attributes));
			
		}elseif($this->tipo_campo_form() == "checkbox" || $this->tipo_campo_form() == "radio"){

			$out .= Form::{$this->tipo_campo_form()}($this->nome_campo, 1, $this->is_checked, array_merge(['class' => ''.join(" ", $this->classi_html)], $this->attributes));
		}elseif($this->tipo_campo_form() == "custom_macro"){

			$out .= $existing_obj->{$this->nome_campo."_macro"}();
			$out .= Form::{$this->nome_campo}();
		}elseif($this->tipo_campo_form() == "parse_value"){

			$out .= Form::text($this->nome_campo, $existing_obj->{$this->parse_function}($this->nome_campo, $this->parse_options), array_merge(['class' => 'form-control '.join(" ", $this->classi_html), 'placeholder' => $this->placeholder], $this->attributes));
		}elseif($this->tipo_campo_form() == "solo_testo"){

			$out .= "<div class='".join(" ", $this->classi_html)."'>";
			$out .= $existing_obj->{$this->nome_campo};
			$out .= "</div>";
		}elseif($this->tipo_campo_form() == "html"){

			$out .= $this->valore_fisso;
		}elseif($this->tipo_campo_form() == "hidden"){

			$out .= Form::{$this->tipo_campo_form()}($this->nome_campo, $this->valore_fisso, array_merge(['class' => 'form-control '.join(" ", $this->classi_html), 'placeholder' => $this->placeholder], $this->attributes));
		}else{

			$out .= Form::{$this->tipo_campo_form()}($this->nome_campo, $this->valore_fisso, array_merge(['class' => 'form-control '.join(" ", $this->classi_html), 'placeholder' => $this->placeholder], $this->attributes));
		}

		if(!$skip_enclosure){
			$out .= "</div>";
		}
		
		return $out;
	}
	
	
	/**
	 * ritorna l'html del valore del campo in oggetto da usare nella modalita' view
	 * 
	 * @param type $existing_obj
	 * @param array $options
	 * @return string
	 * @throws Exception
	 */
	public function print_view_field($existing_obj = null, $options = null){
		
		//controlliamo se l'oggetto e' stato ricevuto direttamente o se dobbiamo aspettarcelo globale a livello di campo
		if(is_object($this->real_obj) && $existing_obj === null){
			$existing_obj = $this->real_obj;
		}
		
		//se nessuno dei due oggetti e' settato andiamo in eccezione
		if(!is_object($existing_obj)){
			throw new \Exception("Object Required in order to print view field!");
		}
		

		//diamo la possibilita' di definire le opzioni di stampa a livello globale di oggetto campo
		if(is_array($this->default_options) && is_array($options)){
			$options = array_merge($this->default_options, $options);
		}elseif(!is_array($options)){			
			if(is_array($this->default_options)){
				$options = $this->default_options;
			}else{
				$options = [];
			}
		}
		
		$out = "";
		
		if(!is_array($options)){
			throw new Exception("options must be an array, ".gettype($options)." given");
		}
		
		$valore = "";
		
		switch($this->tipo_campo_form()){
			
			case "checkbox":
			$valore = ($existing_obj->{$this->nome_campo} == 1 || $this->is_checked) ? "<span class='checkbox_value_si'>S&igrave;</span>" : "<span class='checkbox_value_no'>No</span>";
				break;
				
			case "select":
				$valore = isset($this->opzioni_select[$existing_obj->{$this->nome_campo}]) ? $this->opzioni_select[$existing_obj->{$this->nome_campo}] : "";
				break;

			case "select_linked":
				$valore = isset($this->opzioni_select[$existing_obj->{$this->nome_campo}]["option_value"]) ? $this->opzioni_select[$existing_obj->{$this->nome_campo}]["option_value"] : "";
				break;
			
			case "parse_value":
				$valore = $existing_obj->{$this->parse_function}($this->nome_campo, $this->parse_options_view);
				break;
			
			case "html":
				$valore = $this->valore_fisso;
				break;

			default:
				
				$valore = $existing_obj->{$this->nome_campo};
				break;
		}
		
		
		$skip_enclosure = isset($options["skip_enclosure"])&&is_bool($options["skip_enclosure"]) ? $options["skip_enclosure"] : false;
		$prevent_hidden_attr = isset($options["prevent_hidden_attr"])&&is_bool($options["prevent_hidden_attr"]) ? $options["prevent_hidden_attr"] : true;
		$nbsp = isset($options["nbsp"])&&is_bool($options["nbsp"]) ? $options["nbsp"] : false;
		$read_only = isset($options["read_only"])&&is_bool($options["read_only"]) ? $options["read_only"] : false;
		$write_only = isset($options["write_only"])&&is_bool($options["write_only"]) ? $options["write_only"] : false;
		
		if($write_only){
			return '';
		}
		
		if($nbsp && strlen($valore) == 0){
			$valore.= "&nbsp;";
		}
		
		if(!$skip_enclosure){
			$out .= "<div class='".($read_only?"":"view_form_field")." vff_style'>";
		}
		
		
		if(!$prevent_hidden_attr || array_search($this->nome_campo, $existing_obj->hidden_list()) === false){
			$out .= "<span>".$valore."</span>";
		}
		
		
		if(!$skip_enclosure){
			$out .= "</div>";
		}
		
		return $out;
	}
	
	
	public function print_all_field($existing_obj = null, $options = null){
		return $this->print_view_field($existing_obj, $options).$this->print_input_field($existing_obj, $options);
	}
}