<?php

namespace JSM\Base\Traits;

use \Illuminate\Database\Eloquent\Builder;

trait EditCreateUserID{

	protected $all_enabled = true;
	protected $create_enabled = false;
	protected $update_enabled = false;
	
	protected $updated_by_column = "updated_by";
	protected $created_by_column = "created_by";
	

	protected function isCreateEnabled(){
		return $this->all_enabled || $this->create_enabled;
	}
	
	protected function isUpdateEnabled(){
		return $this->all_enabled || $this->update_enabled;
	}


	protected function performUpdate(Builder $query){
		
		if($this->isUpdateEnabled()){
			$this->{$this->updated_by_column} = auth()->id();
		}
		
		return parent::performUpdate($query);
	}

	
	protected function performInsert(Builder $query){
		
		if($this->isCreateEnabled()){
			$this->{$this->created_by_column} = auth()->id();
		}
		
		return parent::performInsert($query);
	}
	
}