<?php

namespace App\Policies;

use Illuminate\Auth\Access\HandlesAuthorization;

class BasePolicy{

	use HandlesAuthorization;

	public function before($user, $ability){

		if($user->isAdmin()){
			return true;
		}

	}
	
	/**
	 * Determine whether the user can access to the items list.
	 *
	 * @param  App\User  $user
	 * @return mixed
	 */
	public function access(User $user){
		return true;
	}

	/**
	 * Determine whether the user can view the settings.
	 *
	 * @param  App\User  $user
	 * @param  App\Models\Settings  $model_obj
	 * @return mixed
	 */
	public function view(User $user, $model_obj){

		$query = \DB::table($model_obj->getTable())->select($model_obj->getKeyName());
		$query->where($model_obj->getKeyName(), $model_obj->getKey());

		$model_obj::applica_permessi($query, $user);


//			echo \App\Strumenti\Librerie::debug_query($query);
////			var_dump($model_obj);
//			die();

		return ($query->count() > 0);
	}

	/**
	 * Determine whether the user can create settings.
	 *
	 * @param  App\User  $user
	 * @return mixed
	 */
	public function create(User $user){
		return $this->access($user);
	}

	/**
	 * Determine whether the user can update the settings.
	 *
	 * @param  App\User  $user
	 * @param  App\Settings  $model_obj
	 * @return mixed
	 */
	public function update(User $user, $model_obj){
		return $this->view($user, $model_obj);
	}

	/**
	 * Determine whether the user can delete the settings.
	 *
	 * @param  App\User  $user
	 * @param  App\Settings  $model_obj
	 * @return mixed
	 */
	public function delete(User $user, $model_obj){
		return $this->update($user, $model_obj);
	}

}
