<?php

/*
 * Libreria con le funzioni standard "nostre", in modo che possano essere invocate direttamente senza passare da un metodo statico di qualche classe
 * 
 * alla lunga andranno a sostituire tutte le funzioni presenti in Strumenti\Librerie
 */

if(!function_exists("geocode")){

	function geocode($address){

		// url encode the address
		$address = urlencode($address);

		// google map geocode api url
		//$url = "http://maps.google.com/maps/api/geocode/json?address={$address}";

		$url = "https://maps.google.com/maps/api/geocode/json?language=it&address={$address}&key=".config('par.google_api_key', '');

		// get the json response
		$resp_json = file_get_contents($url);

		// decode the json
		$resp = json_decode($resp_json, true);

		// response status will be 'OK', if able to geocode given address
		if($resp['status'] == 'OK'){

			// get the important data
			$lati = $resp['results'][0]['geometry']['location']['lat'];
			$longi = $resp['results'][0]['geometry']['location']['lng'];
			$formatted_address = $resp['results'][0]['formatted_address'];

			// verify if data is complete
			if($lati && $longi && $formatted_address){

				// put the data in the array
				$data_arr = array();

				array_push(
					$data_arr, $lati, $longi, $formatted_address
				);

				return $data_arr;
			}else{
				return false;
			}
		}else{
			return false;
		}
	}

}



if(!function_exists("debug_query")){

	function debug_query($query_builder){

		if(!is_a($query_builder,"Illuminate\Database\Eloquent\Builder") && !is_a($query_builder,"Illuminate\Database\Query\Builder")){
			echo "<p>L'oggetto passato non e' del tipo corretto!"
			."<p>Tipo atteso: <b>Illuminate\Database\Eloquent\Builder</b>"
			."<br />Tipo ricevuto: <b>".get_class($query_builder)."</b>"
			."<p>Puo' essere che sia stato invocato il metodo ->get() prima di passare la \"query\" al metodo di debug";
			die();
		}

		try{
			\DB::connection()->enableQueryLog();

			$query_builder->get();

			//echo "<pre>";
			$sql = \DB::getQueryLog()[0]["query"];
			$dati = \DB::getQueryLog()[0]["bindings"];

			if(isset($dati) && $dati != null && count($dati) > 0){

				if(strpos($sql, "?") !== false){

					//sostituiamo i ? in ordine
					foreach($dati as $value){
						$sql = preg_replace("/\?/", "'".$value."'", $sql, 1);
					}
				}else{
					foreach($dati as $key => $value){
						$sql = str_replace(":".$key, "'".$value."'", $sql);
					}
				}
			}

			$sql = "<pre style='white-space: pre-wrap;'>".$sql."</pre>";
			\DB::connection()->disableQueryLog();
			\DB::connection()->flushQueryLog();
		}catch(\Exception $e){

			$sql = "<p>Siamo qui perch&eacute; la query presenta un errore e quindi non pu&ograve; essere esguito il binding automatico</p>";

			$sql .= "<p><b>Query:</b><pre style='white-space: pre-wrap;'>".$query_builder->toSql()."</pre>";

			$sql .= "<p><b>Bindings:</b> <pre style='white-space: pre-wrap;'>";
			$sql .= json_encode($query_builder->getBindings());
			$sql .= "</pre>";

			$sql .= "<p><b>Eccezione:</b> <pre style='white-space: pre-wrap;'>";
			$sql .= $e->getMessage();
			$sql .= "</pre>";
		}

		return $sql;
	}

}


if(!function_exists("stampa")){

	/**
	 * questa funzione stampa (o ritorna) il valore passato come parametro.
	 * 
	 * se il sito lavora in multi-lingua, cerca se esiste la traduzione per la lingua corrente, 
	 * altrimenti inserisce la parola nel db (in modo da poter essere tradotta in seguito)
	 * 
	 * @param type $testo
	 * @param type $really_print
	 * @param type $js_available
	 * @return type
	 */
	function stampa($testo, $really_print = true, $js_available = false){

		$testo_tradotto = $testo;
		
		if(config("par.MULTILINGUA", false) && !App::runningInConsole()){ //se siamo in console (tipicamente tramite artisan) non eseguiamo le query su DB per le traduzioni
		
			$db_connection = false;
			try{
				\DB::connection()->getPdo();

				if(\DB::connection()->getDatabaseName() && Schema::hasTable('traduzioni')){
					$db_connection = true;
				}else{
					$db_connection = false;
				}
			}catch(\Exception $e){
				$db_connection = false;
			}

			if($db_connection){

				$lingua_sito = \Session::get("lingua_sito", config("par.DEFAULT_USER_LANGUAGE", "ITA")); //recuperiamo la lingua con cui l'utente desidera vedere il sito
				$lingua_default = config("par.DEFAULT_SITE_LANGUAGE"); //questa e' la lingua con cui sono stati scritti tutti i messaggi nel sito
				$colonna_default = "valore_".strtolower($lingua_default); //e questa e' la rispettiva colonna sul DB

				$nome_colonna = "valore_ita";

				switch($lingua_sito){
					case "ITA":
						$nome_colonna = "valore_ita";
						break;
					case "ENG":
						$nome_colonna = "valore_eng";
						break;
					case "SPA":
						$nome_colonna = "valore_spa";
						break;
					default:
						$nome_colonna = "valore_ita";
						break;
				}

				//andiamo a vedere se c'e' gia' il record sul db
				if($lingua_sito != $lingua_default || config("par.FORCE_INSERT", false)){ //in questo modo andiamo a fare connessioni solo se non siamo nel contesto di default
					$result = jsmTraduzioni::where($colonna_default, $testo)->first();

					if($result === null){
						try{
							jsmTraduzioni::create([$colonna_default => $testo, "url_pagina" => substr(\Request::fullUrl(), 0, 250), "js_available" => ($js_available ? 1 : 0)]);
						} catch (\Exception $ex) {
							\Log::error("Errore inserimento traduzione: ".$ex->getMessage());
						}
							
					}else{
						$testo_tradotto = strlen($result->$nome_colonna) > 0 ? $result->$nome_colonna : $testo;
					}
				}
			}
		}


		if($really_print){
			echo $testo_tradotto;
		}else{
			return $testo_tradotto;
		}
	}

}

if(!function_exists("js_translation")){

	function js_translation(){

		$lingua_sito = \Session::get("lingua_sito", config("par.DEFAULT_USER_LANGUAGE", "ITA")); //recuperiamo la lingua con cui l'utente desidera vedere il sito
		$lingua_default = config("par.DEFAULT_SITE_LANGUAGE"); //questa e' la lingua con cui sono stati scritti tutti i messaggi nel sito
		$colonna_default = "valore_".strtolower($lingua_default); //e questa e' la rispettiva colonna sul DB

		$nome_colonna = "valore_ita";

		switch($lingua_sito){
			case "ITA":
				$nome_colonna = "valore_ita";
				break;

			case "ENG":
				$nome_colonna = "valore_eng";
				break;

			default:
				$nome_colonna = "valore_ita";
				break;
		}

		
		$result = array();
		
		if(config("par.MULTILINGUA", false)){
			$db_connection = false;
			try{
				\DB::connection()->getPdo();

				if(\DB::connection()->getDatabaseName() && Schema::hasTable('traduzioni')){
					$db_connection = true;
				}else{
					$db_connection = false;
				}
			}catch(\Exception $e){
				$db_connection = false;
			}

			if($db_connection){
				$arr = jsmTraduzioni::where("js_available", 1)->get();

				foreach($arr as $value){
					$result[$value->$colonna_default] = stampa($value->$colonna_default, false);
				}
			}
		}


		return json_encode($result);
	}

}


if(!function_exists("random_password")){

	/**
	 * restituisce una stringa random (numeri e lettere maiuscole/minuscole) della lunghezza desiderata
	 * 
	 * @param int $length
	 * @param string $lista_caratteri [default null]
	 * @return string
	 */
	function random_password($length = 10, $lista_caratteri = null){

		if($lista_caratteri === null){
			$lista_caratteri = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
		}
		
		$randomString = '';
		for($i = 0; $i < $length; $i++){
			$randomString .= $lista_caratteri[rand(0, strlen($lista_caratteri) - 1)];
		}
		return $randomString;
	}

}

if(!function_exists("log_last_page")){

	function log_last_page(){

//	$last_page = \Request::path();
////	$last_page = "survey";
//	echo "<p>".$last_page."</p>";
//	var_dump(preg_match("/^survey\/[0-9]+$/", $last_page));
//	die();

		$pagina = \Request::path();
		$last_page = null;

		if($pagina == "survey" || $pagina == "raters"){
			$last_page = null;
		}elseif(preg_match("/^survey\/[0-9]+$/", $pagina) || preg_match("/^raters\/[0-9]+$/", $pagina)){
			$last_page = str_replace(\Request::root(), "", \Request::fullUrl());
		}


//	echo "<p>".$request->root();
//	echo "<p>".$request->decodedPath();
//	echo "<p>".$request->fullUrl();
//	
//	echo "<p>";
////	echo "<p>".\Request::url();
//	var_dump($request->query());


		\Auth::user()->ultima_pagina = $last_page;
		\Auth::user()->save();
	}

}

if(!function_exists("put_session_tag")){

	function put_session_tag($nome, $valore){

//	if(!is_array(\Session::get("session_tag", null))){
//		\Session::put("session_tag", array());
//	}

		$sess = \Session::get("session_tag.".$nome, null);
		if(isset($sess)){
			\Session::forget("session_tag.".$nome);
		}

		\Session::push("session_tag.".$nome, $valore);
	}

}

if(!function_exists("get_session_tag")){

	function get_session_tag($nome){
		$item = \Session::get("session_tag.".$nome, null);
		$out = null;

		if($item !== null && isset($item[0])){
			$out = $item[0];
		}
		return $out;
	}

}



if(!function_exists("delete_constraints_sqlserver")){

	/**
	 * Questa funzione cancella la constraint nel campo e nella tabella indicata
	 * @param string $nome_tabella
	 * @param string $nome_campo
	 */
	function delete_constraints_sqlserver($nome_tabella, $nome_campo){

		if(env('DB_CONNECTION', 'mysql') == 'sqlsrv'){

			$arr = \DB::select("SELECT dc.Name AS nome
					FROM sys.tables t
					INNER JOIN sys.default_constraints dc ON t.object_id = dc.parent_object_id
					INNER JOIN sys.columns c ON dc.parent_object_id = c.object_id AND c.column_id = dc.parent_column_id
					WHERE t.Name = ? AND c.Name = ?
					ORDER BY t.Name", [$nome_tabella, $nome_campo]);

			foreach($arr as $constraints){
				\DB::statement('ALTER TABLE '.$nome_tabella.' DROP CONSTRAINT '.$constraints->nome);
			}
		}
	}

}


if(!function_exists("stampa_valuta")){

	/**
	 * ritorna un numero formattato con 2 cifre decimali, eventuali separatori delle migliaia e opzionale simbolo dell'euro
	 * 
	 * @param number $number
	 * @param string $dec_point
	 * @param string $thousands_sep
	 * @param boolean $euro
	 * @return type
	 */
	function stampa_valuta($number, $dec_point = ",", $thousands_sep = ".", $euro = true){
		return number_format($number, 2, $dec_point, $thousands_sep).($euro ? " &euro;" : "");
	}

}

if(!function_exists("TagliaStringa")){

	/**
	* restituisce una stringa tagliata di n caratteri facendo in modo che non vengano interrote le parole
	* 
	* opzionalmente e' possibile fare in modo che venga restituita una stringa con i tag html correttamente richiusi
	* 
	* @param string $stringa testo di partenza
	* @param int $max_char numero di caratteri approssimativo da tenere (si ferma alla fine della parola, se e' a meta')
	* @param bool $repair_html [default: false] se impostato a TRUE chiude eventuali tag HTML rimasti interrotti
	* @param string $encoding [default: utf8] indica la codifica con cui viene riprocessata la stringa se $repair_html = TRUE
	* @param bool $puntini_automatici [default: false] se impostato a TRUE aggiunge automaticamente i puntini di sospensione in caso di stringa tagliata
	* @return string la stringa opportunamente tagliata e modificata
	*/
	function TagliaStringa($stringa, $max_char, $repair_html = false, $encoding="utf8", $puntini_automatici=false){
		
		if(strlen($stringa) > $max_char){
			
			$stringa_tagliata = substr($stringa, 0, $max_char);
            $last_space = strrpos($stringa_tagliata, " ");
            if($last_space == 0){
                $last_space = $max_char;
            }
			$stringa_ok = substr($stringa_tagliata, 0, $last_space);
            
			if($repair_html){
				
				if(class_exists("tidy")){ //se esiste la classe tidy, usiamo quella, che funziona meglio
					$tidy = new tidy();
					$options = array("show-body-only" => true);

					$stringa_ok = $tidy->repairString($stringa_ok, $options, $encoding);
					
				}else{ //altrimenti basiamoci sulle regexpr
					$stringa_ok = truncateHTML($stringa, $last_space);
				}
				
			}
			
			return $stringa_ok.($puntini_automatici ? "..." : "");
		}else{
			return $stringa;
		}
	}



}


if(!function_exists("truncateHTML")){

	function truncateHTML($html, $length)
	{
		$truncatedText = substr($html, $length);
		$pos = strpos($truncatedText, ">");
		if($pos !== false)
		{
			$html = substr($html, 0,$length + $pos + 1);
		}
		else
		{
			$html = substr($html, 0,$length);
		}

		preg_match_all('#<(?!meta|img|br|hr|input\b)\b([a-z]+)(?: .*)?(?<![/|/ ])>#iU', $html, $result);
		$openedtags = $result[1];

		preg_match_all('#</([a-z]+)>#iU', $html, $result);
		$closedtags = $result[1];

		$len_opened = count($openedtags);

		if (count($closedtags) == $len_opened)
		{
			return $html;
		}

		$openedtags = array_reverse($openedtags);
		for ($i=0; $i < $len_opened; $i++)
		{
			if (!in_array($openedtags[$i], $closedtags))
			{
				$html .= '</'.$openedtags[$i].'>';
			}
			else
			{
				unset($closedtags[array_search($openedtags[$i], $closedtags)]);
			}
		}


		return $html;
	}

}


if(!function_exists("verify_local_access")){

	/**
	 * verifica se la richiesta arriva da un indirizzo della stessa rete locale del server (solo se la subnet e' a 24 bit)
	 * 
	 * @param array $ip_esclusi elenco di IP che vengono considerati come se fossero "locali"
	 *
	 * @return boolean
	 */
	function verify_local_access($ip_esclusi = array("127.0.0.1")){
		
		$local_addr = (isset($_SERVER['LOCAL_ADDR']) && is_string($_SERVER['LOCAL_ADDR']) ? (string)$_SERVER['LOCAL_ADDR'] : "");
		
		//cerchiamo l'indirizzo locale per le macchine Linux
		if(strlen($local_addr) === 0){
			$local_addr = (isset($_SERVER['SERVER_ADDR']) && is_string($_SERVER['SERVER_ADDR']) ? (string)$_SERVER['SERVER_ADDR'] : "");
		}
		
		$remote_addr = (isset($_SERVER['REMOTE_ADDR']) && is_string($_SERVER['REMOTE_ADDR']) ? (string)$_SERVER['REMOTE_ADDR'] : "");

		//verifichiamo se la richiesta arriva da uno degli ip consentiti senza onetime
		if(strlen($remote_addr) > 0 && array_search($remote_addr, $ip_esclusi) !== false){
			return true;
		}

		
		
		$server_domain = explode(".", $local_addr);
		$user_domain = explode(".", $remote_addr);

		
		array_pop($server_domain);
		array_pop($user_domain);

		$server_domain = implode($server_domain);
		$user_domain = implode($user_domain);
//		echo "<p>".$_SERVER['SERVER_ADDR']."-".$user_domain;
//		echo "<p>".$server_domain."-".$user_domain;
//		die();
		
		if ($server_domain === $user_domain){ return true; }
		
		return false;
	}
}

if (!function_exists("get_relation_attribute")) {
	
	/**
	 * recupera in modo dinamico un attributo partendo da una relazione (da usare nei metodi belongsTo)
	 * 
	 * @param type $obj oggetto corrente
	 * @param type $relazione nome della relazione
	 * @param type $metodo attributo da recuperare (oppure il nome di un metodo con anche le parentesi () )
	 * @return type valore trovato
	 */
	function get_relation_attribute($obj, $relazione, $metodo){
		
		$out = null;
		$is_metodo = false;
		if(strpos($metodo, "()") !== false){
			$is_metodo = true;
			$metodo = str_replace("()", "", $metodo);
		}
		
		$classe = get_class($obj->$relazione()->getModel()); //recuperiamo il nome della classe a partire dal metodo relazione
		
		if(isset($obj->oggetti_relazione[$relazione])){
			$current_obj = $obj->oggetti_relazione[$relazione];
		}else{
			$current_obj = ($obj->$relazione !== null ? $obj->$relazione : new $classe());
			$obj->oggetti_relazione[$relazione] = $current_obj;
		}
		
		if($is_metodo){
			$out = $current_obj->{$metodo}();
		}else{
			$out = $current_obj->{$metodo};
		}
		return $out;
	}
}


if(!function_exists("check_email")){

	/**
	 * verifica la validita' di un indirizzo mail usando il FILTER_VALIDATE_EMAIL se presente o un'espressione regolare in caso contrario
	 * 
	 * @param string $mail indirizzo da verificare
	 * @return boolean esito della verifica
	 */
	function check_email($mail){

		$esito = false;

		if(strlen($mail) == 0){
			return false;
		}

		if(find_filter("validate_email")){

			if(filter_var($mail, FILTER_VALIDATE_EMAIL) === false){
				$esito = false;
			}else{
				$esito = true;
			}
		}else{

			if(strlen($mail) > 5){
				$pattern = '/^(?!(?:(?:\\x22?\\x5C[\\x00-\\x7E]\\x22?)|(?:\\x22?[^\\x5C\\x22]\\x22?)){255,})(?!(?:(?:\\x22?\\x5C[\\x00-\\x7E]\\x22?)|(?:\\x22?[^\\x5C\\x22]\\x22?)){65,}@)(?:(?:[\\x21\\x23-\\x27\\x2A\\x2B\\x2D\\x2F-\\x39\\x3D\\x3F\\x5E-\\x7E]+)|(?:\\x22(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x21\\x23-\\x5B\\x5D-\\x7F]|(?:\\x5C[\\x00-\\x7F]))*\\x22))(?:\\.(?:(?:[\\x21\\x23-\\x27\\x2A\\x2B\\x2D\\x2F-\\x39\\x3D\\x3F\\x5E-\\x7E]+)|(?:\\x22(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x21\\x23-\\x5B\\x5D-\\x7F]|(?:\\x5C[\\x00-\\x7F]))*\\x22)))*@(?:(?:(?!.*[^.]{64,})(?:(?:(?:xn--)?[a-z0-9]+(?:-+[a-z0-9]+)*\\.){1,126}){1,}(?:(?:[a-z][a-z0-9]*)|(?:(?:xn--)[a-z0-9]+))(?:-+[a-z0-9]+)*)|(?:\\[(?:(?:IPv6:(?:(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){7})|(?:(?!(?:.*[a-f0-9][:\\]]){7,})(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,5})?::(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,5})?)))|(?:(?:IPv6:(?:(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){5}:)|(?:(?!(?:.*[a-f0-9]:){5,})(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,3})?::(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,3}:)?)))?(?:(?:25[0-5])|(?:2[0-4][0-9])|(?:1[0-9]{2})|(?:[1-9]?[0-9]))(?:\\.(?:(?:25[0-5])|(?:2[0-4][0-9])|(?:1[0-9]{2})|(?:[1-9]?[0-9]))){3}))\\]))$/iD';

				if(preg_match($pattern, $mail) === 1){
					$esito = true;
				}
			}
		}

		return $esito;
	}

}


if(!function_exists("find_filter")){

	/**
	 * verifica se e' presente il filtro passato come parametro
	 * 
	 * @param string $filtro nome filtro
	 * @return boolean esito
	 */
	function find_filter($filtro){

		$trovato = false;

		if(!function_exists("filter_list")){
			return false;
		}

		foreach(filter_list() as $value){
			if($value == $filtro){
				$trovato = true;
			}
		}

		return $trovato;
	}

}


if (!function_exists("text_color_bg")) {
	
	/**
	 * ritorna il colore della scritta in modo che sia leggibile a partire dal colore di background passato
	 * 
	 * @param string $bg_color colore di sfondo in formato esadecimale (CC0000 | #CC0000)
     * @param integer $threshold [default 175] soglia oltre la quale usare il bianco come colore
     * 
	 * @return string colore della scritta #000000 | #FFFFFF
	 */
	function text_color_bg($bg_color, $threshold = 175){

        $bg_color = str_replace("#", "", $bg_color);

		if(strlen($bg_color) != 6){
			return '#000000';
        }
        
        if(!is_numeric($threshold)){
            $threshold = 175;
        }
		
		$p1 = hexdec(substr($bg_color, 0, 2));
		$p2 = hexdec(substr($bg_color, 2, 2));
		$p3 = hexdec(substr($bg_color, 4, 2));
		
		$media = round(($p1*299+$p2*587+$p3*114)/1000);
		
		return ($media > $threshold ? '#000000' : '#FFFFFF');
	}
}


if (!function_exists("log_current_url")) {
	
	/**
	 * se il livello di dettaglio dei log e' almeno pari a quello richiesto,
	 * salva nei log le informazioni sulla chiamata http ricevuta
	 * 
	 * @param int $required_log_level indica il livello minimo che il parametro jsm_log.verbose_level deve avere per effettuare il log
	 * @return void
	 */
	function log_current_url($required_log_level = 1){
		
		$verbose_log_level = intval(config("jsm_log.verbose_level", 0));
//		var_dump($verbose_log_level);
//		die();
		
		if($verbose_log_level < $required_log_level){
			return;
		}
		
		$info_log = \Request::input();
		
		\jsmLog::log_event("Log URL", "log_url", $info_log);
	}
}



if (!function_exists("check_CF")) {

	/**
	 * verifica che la stringa passata corrisponda a un codice fiscale valido
	 * 
	 * @param string $cf
	 * @return boolean
	 */
	function check_CF($cf){
			
		if(!is_string($cf)){
			return false;
		}

		if(strlen($cf) != 16){
			return false;
		}

		$cf = strtoupper($cf);
		if(!preg_match("/[A-Z0-9]+$/", $cf)){
			return false;
		}

		$s = 0;

		for($i = 1; $i <= 13; $i += 2){
			$c = $cf[$i];
			if('0' <= $c and $c <= '9'){
				$s += ord($c) - ord('0');
			}else{
				$s += ord($c) - ord('A');
			}
		}

		for($i = 0; $i <= 14; $i += 2){
			$c = $cf[$i];
			switch($c){
				case '0': $s += 1;
					break;
				case '1': $s += 0;
					break;
				case '2': $s += 5;
					break;
				case '3': $s += 7;
					break;
				case '4': $s += 9;
					break;
				case '5': $s += 13;
					break;
				case '6': $s += 15;
					break;
				case '7': $s += 17;
					break;
				case '8': $s += 19;
					break;
				case '9': $s += 21;
					break;
				case 'A': $s += 1;
					break;
				case 'B': $s += 0;
					break;
				case 'C': $s += 5;
					break;
				case 'D': $s += 7;
					break;
				case 'E': $s += 9;
					break;
				case 'F': $s += 13;
					break;
				case 'G': $s += 15;
					break;
				case 'H': $s += 17;
					break;
				case 'I': $s += 19;
					break;
				case 'J': $s += 21;
					break;
				case 'K': $s += 2;
					break;
				case 'L': $s += 4;
					break;
				case 'M': $s += 18;
					break;
				case 'N': $s += 20;
					break;
				case 'O': $s += 11;
					break;
				case 'P': $s += 3;
					break;
				case 'Q': $s += 6;
					break;
				case 'R': $s += 8;
					break;
				case 'S': $s += 12;
					break;
				case 'T': $s += 14;
					break;
				case 'U': $s += 16;
					break;
				case 'V': $s += 10;
					break;
				case 'W': $s += 22;
					break;
				case 'X': $s += 25;
					break;
				case 'Y': $s += 24;
					break;
				case 'Z': $s += 23;
					break;
			}
		}

		if(chr($s % 26 + ord('A')) != $cf[15]){
			return false;
		}
		return true;
	}
}


if (!function_exists("trim_and_printable")) {

	/**
	 * esegue il trim e la rimozione di caratteri non stampabili dalla stringa ricevuta e la ritorna
	 * 
	 * @param string $value
	 */
	function trim_and_printable($value){
		$value = preg_replace('/[[:^print:]]/', "", $value);
		$value = trim($value);
		return $value;
	}
}

if (!function_exists("trim_and_printable_array")) {
	
	/**
	 * cicla tutti gli elementi di un array ed esegue il trim e la rimozione dei caratteri non stampabili
	 * da usare come secondo parametro di array_walk
	 * 
	 * @param type $value
	 * @param type $key
	 */
	function trim_and_printable_array(&$value, &$key){
		$value = trim_and_printable($value);
	}
}

if(!function_exists("download_disk_file")){
	function download_disk_file($disk, $filename, $filepath = "", $force_download = false,$nome_file_download = null){
		
		$filepath = add_ending_slash($filepath);
		
		if(!\Storage::disk($disk)->exists($filepath.$filename)){
			abort(404,"File Not Found");
		}
		
		if($nome_file_download===null || strlen($nome_file_download)==0){
			$nome_file_download = $filename;
		}
		
		$headers = [
			"Content-Type"=>\Storage::disk($disk)->mimetype($filepath.$filename),
			"Content-Disposition" => ($force_download === true ? "attachment; " : "").'filename="'. $nome_file_download .'"',
		];
		
		return \Response::make(\Storage::disk($disk)->get($filepath.$filename), 200, $headers);
	}
}

if(!function_exists("add_ending_slash")){
    
    /**
     * aggiunge l'ultimo slash alla stringa se non e' gia' presente
     * 
     * @param string $dir_name
     * @param type $process_empty
     * @return string
     * @throws Exception
     */
    function add_ending_slash($dir_name, $process_empty = false){
        
        if(!is_string($dir_name)){
            throw new Exception("\$dirname must be a string");
        }
        
        if(strlen($dir_name) == 0 && !$process_empty){
            return "";
        }
        
        $last_char = mb_substr($dir_name, -1);
        
        if($last_char != "/" && $last_char != "\\"){
            $dir_name .= "/";
        }
        
        return $dir_name;
    }
}


if(!function_exists("resizePng")){
    
    /**
     * effettua il resize dell'immagine png
     * 
     * @param resource $im
     * @param int $dst_width
     * @param int $dst_height
     * @return resource $newImg
	 * 
     */
	function resizePng($im, $dst_width, $dst_height) {
		$width = imagesx($im);
		$height = imagesy($im);

		$newImg = imagecreatetruecolor($dst_width, $dst_height);

		imagealphablending($newImg, false);
		imagesavealpha($newImg, true);
		$transparent = imagecolorallocatealpha($newImg, 255, 255, 255, 127);
		imagefilledrectangle($newImg, 0, 0, $width, $height, $transparent);
		imagecopyresampled($newImg, $im, 0, 0, 0, 0, $dst_width, $dst_height, $width, $height);

		return $newImg;
	}
}


if (!function_exists('ddd')) {

    /**
     * andiamo a definire una nuova funzione ddd che riprenda il tema "light" invece del nuovo tema di default scuro
     */
    function ddd(...$vars) {
        
        foreach ($vars as $v) {
            \JSM\Base\txdVarDumper::dump($v);
        }

        die(1);
    }
}

if (!function_exists('jddd')) {

    /**
     * andiamo a definire una nuova funzione jddd che riprenda il tema "light" invece del nuovo tema di default scuro e non si sovrapponga a ddd del nuovo pacchetto per la gestione degli errori
     */
    function jddd(...$vars) {
        
        foreach ($vars as $v) {
            \JSM\Base\txdVarDumper::dump($v);
        }

        die(1);
    }
}


if (!function_exists('language_from_browser')) {

    
    /**
     * recupera la lingua di default del browser
     *
     * @param boolean $put_in_session se true salva la lingua in sessione
     * @param boolean $skip_if_in_session se true e c'è una lingua in sessione la ritorna senza fare altro
     * @return string
     */
    function language_from_browser($put_in_session = false, $skip_if_in_session = false) {
        
        if($skip_if_in_session && session()->has('lingua_sito')){
            return session()->get('lingua_sito');
        }

        $lang = "it";
	
        if(isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])){
            $lang = substr(request()->server("HTTP_ACCEPT_LANGUAGE"), 0, 2);
        }
        
        if($lang === "en"){
            $lingua_sito = "ENG";
        }else{
            $lingua_sito = "ITA";
        }

        if($put_in_session){
            \Session::put("lingua_sito", $lingua_sito);
			\Session::save();
        }

        return $lingua_sito;
    }
}


if (!function_exists("remove_numeric_key_item")) {

	/**
	 * cicla tutti gli elementi dell'array passato e rimuove tutti gli elementi
	 * la cui chiave e' un intero e il cui valore e' NULL
	 *
	 * @param array $array array chiave => valore
     * @return array
	 */
	function remove_numeric_key_item($array){

        foreach($array as $key => $value){
            if(is_int($key) && is_null($value)){
                unset($array[$key]);
            }
        }

        return $array;
	}
}

if(!function_exists("isHttpsURL")){
    
    /**
     * verifica se l'url impostato nel file .env e' in https o meno
     * in questo modo potremo andare a generare a mano gli url opportuni nel caso in cui ci sia di mezzo un proxy o qualcosa di simile
     * per cui l'url automatico sarebbe in http
     * 
     * @return bool
	 * 
     */
	function isHttpsURL() {
		return str_contains(\Config::get('app.url'), 'https://');
	}
}