<?php

namespace JSM\Base;

use JSM\Base\txdAttributes;

class txdFields implements \IteratorAggregate {
	
    protected $item_obj_list = [];
    protected $current_model_obj;


	public function __construct($current_model_obj){
		$this->current_model_obj = $current_model_obj;
	}
    
    public function getIterator() {
		return new \ArrayIterator($this->item_obj_list);
    }

    /**
     * aggiunge un attributo all'elenco
     * 
     * @param string $nome nome del campo su DB
     * @param string $tipo [default: text] tipo di attributo (text, email, password, data, select, etc...)
     * @param string $etichetta [default: ""] eventuale etichetta da stampare
     * @param array $classi_html elenco di classi da passare al campo
     * 
     * @return txdAttributes
     */
    public function add($nome, $tipo = "text", $etichetta = "", $classi_html = []){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }

        $tmp = new txdAttributes($nome, $tipo, $etichetta, $classi_html);
        $tmp->set_current_model_obj($this->current_model_obj);
        $this->item_obj_list[$nome] = $tmp;

        $tmp->parse_model_rules();

        return $tmp;
    }

    /**
     * ritorna il campo passato come parametro se presente, NULL altrimenti
     * 
     * @return mixed txdAttributes|NULL
     */
    public function retrieve($nome_campo){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
        return $this->item_obj_list[$nome_campo] ?? null;
    }

    /**
     * imposta il modello di partenza all'interno del campo corrente
     * 
     * @param object $obj
     */
    public function set_current_model_obj($obj){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
        $this->current_model_obj = $obj;
    }

    /**
     * invoca il metodo inizializzaCampi del modello su cui sono stati costruiti gli attributi
     * in modo che siano disponibili nell'array db_fields del modello
     * 
     * @return array item_obj_list
     */
    public function build(){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }

        foreach($this->item_obj_list as $obj){
            $obj->finalizza_info();
        }
        
        $this->current_model_obj->set_db_fields($this);
        $this->current_model_obj->inizializzaCampi();
    }

}