<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class TraduzioniCreate extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if (!Schema::hasTable('traduzioni')) {
			Schema::create('traduzioni', function (Blueprint $table) {
				$table->bigIncrements('id');
				$table->longText('valore_ita')->nullable();
				$table->longText('valore_eng')->nullable();
				$table->string('url_pagina')->nullable();
				$table->tinyInteger("js_available")->default(0);
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('traduzioni');
    }
}
