<?php

namespace JSM\Base\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Response;

class checkGate
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next, $nome_gate, ...$params)
    {
		if(!Auth::check()){
			return redirect("/login");
		}
		
		if(!\Gate::allows($nome_gate, ...$params)){
			return new Response(view(view()->exists('errors.access_denied') ? 'errors.access_denied' : 'errors.error_page', ["title" => "Forbidden"]));
		}
		
		
        return $next($request);
    }
}
