<?php
namespace JSM\Base\FieldTypes;
/**
 * Tipo txdAttributes per datatime
 */
class Datetime extends Text {
    public function __construct($nome, $etichetta = "", $classi_html = []){
        parent::__construct($nome,"datatime",$etichetta, $classi_html);
    }

    public function parse_valore($valore) {
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
        if(!isset($this->parse_options["format"])){
            $this->parse_options["format"] = "d/m/Y H:i:s";
        }
        return \classe_data::stampa_data($valore,$this->parse_options);
    }

    public function init_tipo(){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
        $this->add_classe_html("datatime_picker");
        $this->set_model_type("datetime");
    }

    public function tipo_campo_form(){
        return "parse_value";
    }
}