<?php
namespace JSM\Base\FieldTypes;
/**
 * Tipo txdAttributes per select
 */
class Select extends \JSM\Base\txdAttributes {
    public function __construct($nome, $etichetta = "", $classi_html = []){
        parent::__construct($nome,"select",$etichetta, $classi_html);
    }

    /**
     * se il valore corrente è presente tra le opzioni ritorniamo l'etichetta corrispondente. altrimenti ritorniamo il valore vuoto
     *
     * @param [type] $valore
     * @return void
     */
    public function parse_valore($valore) {
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }

        if(isset($this->opzioni_select[$valore])){
            if(is_array($this->opzioni_select[$valore])){
                $valore = $this->opzioni_select[$valore]['option_value'];
            }else{
                $valore = $this->opzioni_select[$valore];
            }
        }else{
            $valore = "";
        }

        return $valore;
    }

    public function init_tipo(){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
    }

    public function tipo_campo_form(){
        return "select";
    }

    public function build_view(){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
        return e($this->get_valore());
    }

    public function build_edit(){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
        return view("txd::FieldTypes.Select",["campo_obj"=>$this]);
    }
}