<?php
namespace JSM\Base\FieldTypes;
/**
 * Tipo txdAttributes per textarea
 */
class Textarea extends \JSM\Base\txdAttributes {
    public function __construct($nome, $etichetta = "", $classi_html = []){
        parent::__construct($nome,"textarea",$etichetta, $classi_html);
    }

    public function parse_valore($valore) {
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
        return $valore;
    }

    public function init_tipo(){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
    }

    public function tipo_campo_form(){
        return "textarea";
    }

    public function build_view(){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
        return e($this->get_valore());
    }

    public function build_edit(){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
        return view("txd::FieldTypes.Text",["campo_obj"=>$this]);
    }
}