<?php

//namespace JSM\Base;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;


abstract class jsmModel extends Model{

	use ValidatingTrait;
	protected $rules = [];

    public $oggetti_relazione = [];  //serve per la funzione get_relation_attribute
    
    private $html_capable_fields = []; //contiene i campi per i quali e' ammesso l'html, quindi verranno passati attraverso la funzione clean, sia per sistemarli che per evitare XSS


	protected $validationMessages = [
		"numeric" => "Il campo &quot;:attribute&quot; deve essere numerico",
		"integer" => "Il campo &quot;:attribute&quot; deve contenere un numero intero",
        "date_nullable" => "Inserire una data valida (gg/mm/aaaa | aaaa-mm-gg) oppure lasciare vuoto il campo",
        "time" => "Inserire un orario valido (hh:mm | hh:mm:ss)",
		"numeric_nullable" => "Inserire un valore numerico oppure lasciare vuoto il campo",
		"txd_json" => "Inserire un json valido",
		"required" => " ",
	];

	
	public function __construct(array $attributes = []){
		
		//settiamo il formato della data se siamo su Linux e il DB e' SQL Server, altrimenti Carbon non riesce a costruire l'oggetto datetime correttamente
		if(config("database.default", "mysql") === "sqlsrv" && (php_uname("s") === "Linux" || env("OS") === "Linux")){
			$this->dateFormat = 'Y-m-d H:i:s';
		}
		
        parent::__construct($attributes);
        
        // $this->validationMessages = array_merge($this->validationMessages, [
        //     "numeric" => stampa("Il campo &quot;:attribute&quot; deve essere numerico", false),
        //     "integer" => stampa("Il campo &quot;:attribute&quot; deve contenere un numero intero", false),
        //     "date_nullable" => stampa("Inserire una data valida (gg/mm/aaaa | aaaa-mm-gg) oppure lasciare vuoto il campo", false),
        //     "date" => stampa("Inserire una data valida (gg/mm/aaaa | aaaa-mm-gg) oppure lasciare vuoto il campo", false),
        //     "time" => stampa("Inserire un orario valido (hh:mm | hh:mm:ss)", false),
        //     "numeric_nullable" => stampa("Inserire un valore numerico oppure lasciare vuoto il campo", false),
        //     "required" => " ",
        // ]);

	}
    

    /**
     * permette di impostare un messaggio custom nel caso in cui fallisca la validazione di un campo
     * 
     * @param string $chiave campo per cui impostare la regola: e' possibile passare solo il nome o anche nome.condizione (es codice_fiscale.unique)
     * @param string $valore messaggio da mostrare in caso di regola non passata
     */
    public function set_validation_message($chiave, $valore){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }

        $this->validationMessages[$chiave] = $valore;
    }

    
	public function newEloquentBuilder($query)
	{
		return new jsmBuilder($query);
	}
	
	/**
	 * estendiamo il metodo base per fare in modo di processare gli input applicando le nostre conversioni prima di validare i dati
	 * 
	 * @param type $key
	 * @return type
	 */
	public function getAttributeValue($key){

		$val = parent::getAttributeValue($key);
		
		if(is_string($val)){
			self::parse_input_saving($this->getModel(), $key, $val);
		}
		
		return $val;
	}
	

	public static function boot(){
		
		parent::boot();

		static::creating(function($model){
			foreach($model->attributes as $key => $value){
				
				self::parse_input_saving($model, $key, $value);
//				$model->{$key} = empty($value) && $value !== 0 && $value !== 0.0 && $value !== "0" ? null : $value;
				$model->{$key} = $value;
			}
		});

		static::updating(function($model){
			
			foreach($model->attributes as $key => $value){
				
				self::parse_input_saving($model, $key, $value);
//				$model->{$key} = empty($value) && $value !== 0 && $value !== 0.0 && $value !== "0" ? null : $value;
				$model->{$key} = $value;
			}
			
		});
		
		
		/*
		 * aggiungiamo i log di default per i 3 metodi standard: create, update e delete
		 */
		
		static::created(function($model){
			
			/*
			 * log locali
			 */
			try{

				$reflect = new \ReflectionClass($model);
				
				if(class_exists("jsmLog") === false || array_search($reflect->getShortName(), jsmLog::$excluded_class) !== false){
					return;
				}
				
				$info = array();
				$info["id"] = $model !== null ? $model->getKey() : null;
				$info["file_name"] = $reflect->getFileName();

				jsmLog::log_event("create ".$reflect->getShortName(), "insert", $info, $model);
				
			}catch(\Exception $ex){
				Log::error("Errore creazione log: ".$ex->getMessage());
				
				if(config('app.debug')){
					throw $ex;
				}
			}
			
			
			/*
			 * log documentazione
			 */
			try{

				if(class_exists("jsmDoc") === false){
					return;
				}
				
				$reflect = new \ReflectionClass($model);
				jsmDoc::log_method("created", $reflect->getName(), $reflect->getFileName(), null, __FILE__);
				
			}catch(\Exception $ex){
				Log::error("Errore creazione documentazione: ".$ex->getMessage());
				
				if(config('app.debug')){
					throw $ex;
				}
			}
			
		});
		
		
		static::updated(function($model){
			
			/*
			 * log locali
			 */
			try{

				$reflect = new \ReflectionClass($model);
				
				if(class_exists("jsmLog") === false || array_search($reflect->getShortName(), jsmLog::$excluded_class) !== false){
					return;
				}
				
				$info = array();
				$info["id"] = $model !== null ? $model->getKey() : null;
				$info["file_name"] = $reflect->getFileName();

				jsmLog::log_event("update ".$reflect->getShortName(), "update", $info, $model);
				
			}catch(\Exception $ex){
				Log::error("Errore creazione log: ".$ex->getMessage());
				
				if(config('app.debug')){
					throw $ex;
				}
			}
			
			
			/*
			 * log documentazione
			 */
			try{

				if(class_exists("jsmDoc") === false){
					return;
				}
				
				$reflect = new \ReflectionClass($model);
				jsmDoc::log_method("updated", $reflect->getName(), $reflect->getFileName(), null, __FILE__);
				
			}catch(\Exception $ex){
				Log::error("Errore creazione documentazione: ".$ex->getMessage());
				
				if(config('app.debug')){
					throw $ex;
				}
			}
			
		});
		
		
		static::deleted(function($model){
			
			try{

				$reflect = new \ReflectionClass($model);
				
				if(class_exists("jsmLog") === false || array_search($reflect->getShortName(), jsmLog::$excluded_class) !== false){
					return;
				}
				
				$info = array();
				$info["id"] = $model !== null ? $model->getKey() : null;
				$info["file_name"] = $reflect->getFileName();

				jsmLog::log_event("delete ".$reflect->getShortName(), "delete", $info, $model);
				
			}catch(\Exception $ex){
				Log::error("Errore creazione log: ".$ex->getMessage());
				
				if(config('app.debug')){
					throw $ex;
				}
			}
			
			
			/*
			 * log documentazione
			 */
			try{

				if(class_exists("jsmDoc") === false){
					return;
				}
				
				$reflect = new \ReflectionClass($model);
				jsmDoc::log_method("deleted", $reflect->getName(), $reflect->getFileName(), null, __FILE__);
				
			}catch(\Exception $ex){
				Log::error("Errore creazione documentazione: ".$ex->getMessage());
				
				if(config('app.debug')){
					throw $ex;
				}
			}
		});
	}

	
	/**
	 * la funzione trasforma il dato ricevuto sulla base del tipo in modo che venga salvato correttamente su DB
	 * 
	 * @param type $model
	 * @param type $key
	 * @param type $value
	 */
	public static function parse_input_saving($model, $key, &$value){
		
        $type = '';
        
        //se il campo e' presente nella lista dei campi "html" purifichiamone il contenuto
        if(array_search($key, $model->html_fields(), true) !== false){
            $value = clean($value);
        }

        
		if(isset($model->types[$key])){
				
			$type = $model->types[$key];

			if(!empty($value)){
				switch($type){

					case "float":

						if(strpos($value, ".") !== false && strpos($value, ",") !== false){

							$value = str_replace(".", "", $value);
							$value = str_replace(",", ".", $value);

						}elseif(strpos($value, ",") !== false){ //se c'e' solo la virgola, sostituiamola con il punto
							$value = str_replace(",", ".", $value);
						}

						break;

					case "valuta":

						if(strpos($value, ".") !== false && strpos($value, ",") !== false){

							$value = str_replace(".", "", $value);
							$value = str_replace(",", ".", $value);

						}elseif(strpos($value, ",") !== false){ //se c'e' solo la virgola, sostituiamola con il punto
							$value = str_replace(",", ".", $value);

						}elseif(strpos($value, ".") !== false){ //se c'e' solo il punto, ipotizziamo che la valuta abbia al massimo due cifre decimali

							$arr = explode(".", $value);

							if(strlen($arr[1]) === 3){ //dovrebbero essere le migliaia, quindi togliamo il punto
								$value = str_replace(".", "", $value);
							}

						}

						break;

					case "date":
						$data_obj = new classe_data($value);
						
						if(!$data_obj->data_error()){
							$value = $data_obj->print_data("Y-m-d");
						}
						
						break;

					case "datetime":
						$data_obj = new classe_data($value);
						
						if(!$data_obj->data_error()){
							$value = $data_obj->print_data("Y-m-d H:i:s");
						}
						
						break;
					
					default:
						break;
				}
			}
		}
		
		if($type !== 'empty_string'){
			$value = (empty($value) && $value !== 0 && $value !== 0.0 && $value !== "0" ? null : $value);
		}
		
	}
	
	
	/**
	 * [DEPRECATED]
	 * 
	 * genera automaticamente l'elenco delle option di un menu a tendina
	 * 
	 * @param string $nome il campo di cui stampare il valore;<br />
	 * puo' essere: il nome di un campo del modello corrente; una relazione getRelazione.nome_campo; un metodo get_nome()
	 * @param type $valore
	 * @param type $campo_ordine
	 * @param type $allow_empty
	 * @return type
	 */
	public static function option_select($nome, $valore, $campo_ordine="", $allow_empty = true, $metodo_filtro = NULL, $opzioni_filtro = array()){
		
		if(config("app.env") === "local" || config("app.env") === "test"){
			throw new Exception("Metodo Deprecato: option_select(). Passare alla nuova versione \"option_select_2()\"");
		}
		
		
		/*
		 * log documentazione
		 */
		if(class_exists("jsmDoc")){

			try{

				$reflect = new \ReflectionClass(get_called_class());
				\jsmDoc::log_method(__FUNCTION__, $reflect->getName(), $reflect->getFileName(), null, __FILE__);
	//			\jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__);

			}catch(\Exception $ex){
				\Log::error("Errore creazione documentazione: ".$ex->getMessage());

				if(config('app.debug')){
					throw $ex;
				}
			}
		}

		
		$result = array();
		if($allow_empty){
			$result[""] = "--";
		}

		$table_name = with(new static)->getTable();
		$custom_sort = true;
		$tipo_ordinamento = "ASC";
		
		// andiamo a vedere se c'e' anche un'indicazione di come ordinare i campi
		if(strlen($campo_ordine) > 0 && strpos($campo_ordine, "|") !== false){
			$el_ordine = explode("|", $campo_ordine);
			
			$campo_ordine = trim($el_ordine[0]);
			
			$ordinamento_plausibile = strtoupper(trim($el_ordine[1]));
			if($ordinamento_plausibile == "ASC" || $ordinamento_plausibile == "DESC"){
				$tipo_ordinamento = $ordinamento_plausibile;
			}
			
		}

		if(strlen($campo_ordine) == 0 || !in_array($campo_ordine, \Schema::getColumnListing($table_name))){
			$campo_ordine = \Schema::getColumnListing($table_name)[0];
			$custom_sort = false;
		}

//		foreach(self::orderBy($campo_ordine)->get() as $value){
//			$result[$value->$valore] = $value->$nome;
//		}
		
		$obj = self::orderBy($campo_ordine, $tipo_ordinamento);
//		self::applica_permessi($obj);
		
		$nome_classe = get_called_class(); //in questo modo recuperiamo l'istanza della classe figlia
		$nome_classe::applica_permessi($obj);
		
				
		if(method_exists($nome_classe, $metodo_filtro)){
			$nome_classe::$metodo_filtro($obj, $opzioni_filtro);			
		}
		
		$is_metodo = false;
		if(strpos($nome, "()") !== false){
			$is_metodo = true;
			$nome = str_replace("()", "", $nome);
		}
//		echo debug_query($obj);
//		die();
		foreach($obj->get() as $value){
			if($is_metodo){
				$result[$value->$valore] = $value->{$nome}();
			}else{
				$result[$value->$valore] = $value->{$nome};
			}
		}
		
		if(!$custom_sort){
			asort($result);
		}
		
		return $result;
	}
	

	/**
	 * genera automaticamente l'elenco delle option di un menu a tendina
	 * 
	 * @param string $nome il campo di cui stampare il valore;<br />
	 * puo' essere: il nome di un campo del modello corrente; una relazione getRelazione.nome_campo; un metodo get_nome()
	 * @param type $valore
	 * @param type $campo_ordine
	 * @param type $allow_empty
	 * @param type $metodo_filtro
	 * @param type $opzioni_filtro
	 * @param array $additional_options array con opzioni aggiuntive (as esempio il metodo per collegare le tendine)
	 * @return type
	 * @throws \Exception
	 */
	public static function option_select_2($nome, $valore, $campo_ordine="", $allow_empty = true, $metodo_filtro = NULL, $opzioni_filtro = array(), $additional_options = []){
		
		/*
		 * log documentazione
		 */
		if(class_exists("jsmDoc")){

			try{

				$reflect = new \ReflectionClass(get_called_class());
				\jsmDoc::log_method(__FUNCTION__, $reflect->getName(), $reflect->getFileName(), null, __FILE__);
	//			\jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__);

			}catch(\Exception $ex){
				\Log::error("Errore creazione documentazione: ".$ex->getMessage());

				if(config('app.debug')){
					throw $ex;
				}
			}
		}

		if(!is_array($additional_options)){
			$additional_options = [];
		}
		
		
		$relazione = $additional_options["relazione"] ?? null; //nome della colonna con il riferimento all'id della tenedina padre, la cui variazione determina quali elementi mostrare di questa entita'
		$with_trashed = $additional_options["with_trashed"] ?? false;
		
		$result = array();
		if($allow_empty){
			$result[""] = "--";
		}

		$table_name = with(new static)->getTable();
		$custom_sort = true;
		$tipo_ordinamento = "ASC";
		
		// andiamo a vedere se c'e' anche un'indicazione di come ordinare i campi
		if(strlen($campo_ordine) > 0 && strpos($campo_ordine, "|") !== false){
			$el_ordine = explode("|", $campo_ordine);
			
			$campo_ordine = trim($el_ordine[0]);
			
			$ordinamento_plausibile = strtoupper(trim($el_ordine[1]));
			if($ordinamento_plausibile == "ASC" || $ordinamento_plausibile == "DESC"){
				$tipo_ordinamento = $ordinamento_plausibile;
			}
			
		}

		if(strlen($campo_ordine) == 0 || !in_array($campo_ordine, \Schema::getColumnListing($table_name))){
			$campo_ordine = \Schema::getColumnListing($table_name)[0];
			$custom_sort = false;
		}

//		foreach(self::orderBy($campo_ordine)->get() as $value){
//			$result[$value->$valore] = $value->$nome;
//		}
		
		$obj = self::orderBy($campo_ordine, $tipo_ordinamento);
		
		if($with_trashed){
			$obj->withTrashed();
		}
//		self::applica_permessi($obj);
		
		$nome_classe = get_called_class(); //in questo modo recuperiamo l'istanza della classe figlia
		$nome_classe::applica_permessi($obj);
		
				
		if(method_exists($nome_classe, $metodo_filtro)){
			$nome_classe::$metodo_filtro($obj, $opzioni_filtro);			
		}
		
		$is_metodo = false;
		if(strpos($nome, "()") !== false){
			$is_metodo = true;
			$nome = str_replace("()", "", $nome);
        }
        

        $is_metodo_relazione = false;
		if(strpos($relazione, "()") !== false){
			$is_metodo_relazione = true;
			$relazione = str_replace("()", "", $relazione);
        }
        

//		echo debug_query($obj);
//		die();
		
		if($relazione === null){ //se non abbiamo specificato una relazione, gestiamo l'array in modo standard chiave => valore
		
			foreach($obj->get() as $value){
				if($is_metodo){
					$result[$value->$valore] = $value->{$nome}();
				}else{
					$result[$value->$valore] = $value->{$nome};
				}
			}

			if(!$custom_sort){
				asort($result);
			}
			
		}else{

            
			
			foreach($obj->get() as $value){


                
                if($is_metodo_relazione){
                    $data_rif = ($value->{$relazione}() ?? "ALL");
                }else{
                    $data_rif = ($value->{$relazione} ?? "ALL");
                }
				
				
				if($is_metodo){
					$result[$value->$valore] = [
						"option_value" => $value->{$nome}(),
						"data-rif" => $data_rif,
					];
				}else{
					$result[$value->$valore] = [
						"option_value" => $value->{$nome},
						"data-rif" => $data_rif,
					];
				}
			}
			
		}
		
//		dd($result);
		return $result;
	}
	
	
	public static function option_select_si_no($allow_empty = true){
		
		$result = array();
		if($allow_empty){
			$result[""] = "--";
		}
		
		$result[0] = 'No';
		$result[1] = 'Sì';
		
		
		return $result;
	}
	
	
	
	public static function applica_permessi(&$builder_obj, $user_obj = null){
		/*
		 * questo metodo funge solo da placeholder, ogni modello che vuole implementare i permessi dovra' estendere questo metodo
		 */

        //log documentazione -- DA DECOMMENTARE QUANDO LO SI IMPLEMENTA!
		// if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
	}

	
	public function stampa_data($nome_campo, $options = array()){
		return classe_data::stampa_data($this->$nome_campo, $options);
	}
	
	/**
	 * @param mixed $nome_campo
	 * @param array $options
	 * 
	 * @return string
	 * @deprecated
	 */
	public function stampa_dataTime($nome_campo, $options = array()){
		
		if(!isset($options["format"])){
			$options["format"] = "d/m/Y H:i:s";
		}
		return classe_data::stampa_data($this->$nome_campo, $options);
		//return classe_data::stampa_dataTime($this->$nome_campo);
	}
	

	/**
	 * formatta un numero in valuta, a seconda dei parametri
	 * 
	 * @param string $nome_campo nome del campo da formattare
	 * @param array $options array chiave => valore <br>permette di impostare le opzioni di stampa ["thousand" => true | false, "euro" => true | false]
	 * <br> e' stato mantenuto il vecchio significato di thousand, per cui se e' un booleano invece di un array, agisce solo sulla stampa o meno del separatore di migliaia
	 * @param boolean $euro [deprecated]
	 * @return string testo formattato
	 */
	public function stampa_valuta($nome_campo, $options = true, $euro = false){
		
		//facciamo in modo che il secondo parametro possa essere in realta' un array di opzioni che va a includere il precedente significato di "thousand"
		$opzioni_reali = [];
		
		if(is_array($options)){
			$opzioni_reali = $options;
		}
		
		if(isset($opzioni_reali["thousand"])){
			$thousand = $opzioni_reali["thousand"];
		}else{
			$thousand = (is_bool($options) ? $options : true);
		}
		
		if(isset($opzioni_reali["euro"])){
			$euro = $opzioni_reali["euro"];
		}
		
		//se il campo passato fa parte di una relazione (es: getOggetto.nome), chiamiamo la funzione e quindi l'attributo
		if(strpos($nome_campo, ".") !== false){
			$rel = explode(".", $nome_campo)[0];
			$nome_campo = explode(".", $nome_campo)[1];
			
			$value = $this->$rel->$nome_campo;
		}else{
			$value = $this->$nome_campo;
		}
		$formatted = $value;
		if(is_numeric($value)){
			$formatted = number_format($value, "2", ",", ($thousand ? "." : ""));
			
			if($euro){
				$formatted .= " &euro;";
			}
		}
		
		return $formatted;
	}
	
	
	public function fillable_list(){
		return $this->fillable;
	}

	public function hidden_list(){
		return $this->hidden;
	}
    
    /**
     * aggiunge un attributo all'elenco dei campi che supportano l'html
     * 
     * @param string $nome_campo
     */
    public function add_html_field($nome_campo){
        if(array_search($nome_campo, $this->html_capable_fields, true) === false){
            $this->html_capable_fields[] = $nome_campo;
        }
    }

    /**
     * rimuove l'attributo passato dall'elenco dei campi che supportano l'html
     * 
     * @param string $nome_campo
     */
    public function remove_html_field($nome_campo){
        if (($key = array_search($nome_campo, $this->html_capable_fields, true)) !== false) {
            unset($this->html_capable_fields[$key]);
        }
    }

    /**
     * ritorna l'elenco dei campi che supportano html
     * 
     * @return array
     */
    public function html_fields(){
        return $this->html_capable_fields;
	}
	
	/**
	 * ritorna i componenti necessarida visualizzare in view per i campi di tipo file
	 * route => la route che viene chiamata dal link
	 * icon => la parte html grafica (iconda pdf/excel/...)
	 * label => eventuale eticehtta da mettere dopo l'icona
	 *
	 * @param string $nome_campo
	 * @return array
	 */
	public function download_url($nome_campo){

        \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__);

        if($this->{$nome_campo} === null){
            return $this->{$nome_campo};
        }

        $route = "route"; //esempio => route("specifiche.get_file", ["id" => $this->getKey(), "nome_file" => $this->{$nome_campo}]);
        $icon = '<i class="icon-picture_as_pdf" style="cursor: pointer; color: red;"></i>';
        $label = '';

        return ["route" => $route, "icon" => $icon, "label" => $label];

    }


	protected static $db_columns = null;

	/**
	 * verifica se la stringa ricevuta e' un attributo (dinamico, presente su DB) del Modello corrente
	 *
	 * @param string $attr
	 * @return boolean
	 */
	public function hasDBAttribute($attr){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
		
		self::$db_columns = (self::$db_columns ?? \Schema::getColumnListing($this->getTable()));
		
        return in_array($attr, self::$db_columns ?? []);
    }
}
