<?php

namespace JSM\Base\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Response;

class CheckPHPVersion
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next, $versione=70000)
    {
        if(!is_numeric($versione)){
            $versione = 70000;
        }

        if(defined("PHP_VERSION_ID") && PHP_VERSION_ID < $versione){

            $messaggio = "Attenzione! Versione di PHP diversa da quella richiesta. Attesa: ".$versione." -- Rilevata: ".PHP_VERSION_ID;
            \Log::warning($messaggio);

            if(app()->environment("local") || app()->environment("home") || app()->environment("test") || app()->environment("demo")){
                throw new \Exception($messaggio);
            }
        }
		

        return $next($request);
    }
}
