<?php

namespace JSM\Base;

use Illuminate\Support\ServiceProvider;

class jsmServiceProvider extends ServiceProvider{

	/**
	 * Bootstrap the application services.
	 *
	 * @return void
	 */
	public function boot(){
        // $this->publishes([
        //     __DIR__.'/JSM' => base_path('app/JSM'),
        // ], "jsm");

		// $this->publishes([
		// 	__DIR__.'/Mail' => base_path('app/Mail'),
		// ], "mail");

		
		$this->publishes([
			__DIR__.'/views/mail' => base_path('resources/views/mail'),
		], "mail_views");

		$this->publishes([
			__DIR__.'/Policies' => base_path('app/Policies'),
		], "policies");

		$this->publishes([
			__DIR__.'/config/jsm_log.php' => config_path('jsm_log.php'),
		], "log");

		$this->publishes([
			__DIR__.'/config/jsm_datafilter.php' => config_path('jsm_datafilter.php'),
		], "jsm_datafilter");


		$this->publishes([
			__DIR__.'/config/jsm_tables_names.php' => config_path('jsm_tables_names.php'),
        ], "jsm_tables_names");
        
        $this->publishes([
			__DIR__.'/config/jsm_browser_languages.php' => config_path('jsm_browser_languages.php'),
		], "jsm_browser_languages");


		$this->loadMigrationsFrom(__DIR__.'/Migrations');


		$this->mergeConfigFrom(
			__DIR__.'/config/jsm_log.php', 'jsm_log'
		);

		$this->mergeConfigFrom(
			__DIR__.'/config/jsm_tables_names.php', 'jsm_tables_names'
		);

		$this->mergeConfigFrom(
			__DIR__.'/config/jsm_datafilter.php', 'jsm_datafilter'
		);

		$this->mergeConfigFrom(
			__DIR__.'/config/jsm_maintenance.php', 'jsm_maintenance'
        );
        
        $this->mergeConfigFrom(
			__DIR__.'/config/jsm_browser_languages.php', 'jsm_browser_languages'
		);

		// $this->loadRoutesFrom(__DIR__.'/routes.php');

		\Route::group([
			'middleware' => 'web',
				//'namespace' => $this->namespace,
				], function ($router){
			require __DIR__.'/routes.php';
		});

		$this->app->make('JSM\Base\Controllers\jsmController');
        app('router')->aliasMiddleware("local_dev_only", \JSM\Base\Middleware\LocalDevOnly::class);
        app('router')->aliasMiddleware("check_php_version", \JSM\Base\Middleware\CheckPHPVersion::class);


		/*
		 * andiamo a registrare alcune estensioni del Validator
		 */
		\Validator::extend('date_nullable', function($attribute, $value, $parameters, $validator) {

			if($value === null){
				return true;
			}

            $tmp = \Validator::make([$attribute => $value], [$attribute => "date"]);
			return $tmp->passes();
        });

        \Validator::extend('time', function($attribute, $value, $parameters, $validator) {

			// if($value === null){
			// 	return true;
			// }

            $tmp = \Validator::make([$attribute => $value], [$attribute => "date_format:H:i"]);
            $tmp2 = \Validator::make([$attribute => $value], [$attribute => "date_format:H:i:s"]);

			return $tmp->passes() || $tmp2->passes();
        });

		\Validator::extend('numeric_nullable', function($attribute, $value, $parameters, $validator) {

			if($value === null){
				return true;
			}

            $tmp = \Validator::make([$attribute => $value], [$attribute => "numeric"]);
			return $tmp->passes();
        });

		\Validator::extend('integer_nullable', function($attribute, $value, $parameters, $validator) {

			if($value === null){
				return true;
			}

            $tmp = \Validator::make([$attribute => $value], [$attribute => "integer"]);
			return $tmp->passes();
		});

		\Validator::extend('email_nullable', function($attribute, $value, $parameters, $validator) {

			if($value === null){
				return true;
			}

            $tmp = \Validator::make([$attribute => $value], [$attribute => "email"]);
			return $tmp->passes();
        });

		\Validator::extend('txdJson', function($attribute, $value, $parameters, $validator) {
			$value = json_decode($value,true);
			//dd($value)
			return $value !== null; 
		});

        /**
         * andiamo a gestire la riscrittura degli url sulla base dei parametri
         */

        //se previsto dall'opzione, sostituiamo la base dell'url con quello presente nel file .env
        if(config("jsm_datafilter.root_url_from_env", false)){
            \URL::forceRootUrl(\Config::get('app.url'));

            //serve anche qui per compatibilita' con il comportamento nei filtri
            if(isHttpsURL()){
                \URL::forceScheme('https');
            }
        }

        //se l'url nel file env e' in https, generiamo in questo modo anche l'url del form
        if(isHttpsURL() && config("jsm_datafilter.use_env_for_https", false)){
            \URL::forceScheme('https');
        }
	}

	/**
	 * Register the application services.
	 *
	 * @return void
	 */
	public function register(){
		// include __DIR__.'/routes.php';
		// $this->app->make('JSM\Base\Controllers\jsmController');
		$this->app->make('JSM\Base\Controllers\MainController');

		try{
			$this->app['router']->aliasMiddleware('isAdmin', 'JSM\Base\Middleware\isAdmin');
			$this->app['router']->aliasMiddleware('checkGate', 'JSM\Base\Middleware\checkGate');
			$this->app['router']->aliasMiddleware('browser_language', \JSM\Base\Middleware\BrowserLanguage::class);
			// $this->app['router']->aliasMiddleware('CheckForMaintenance', 'JSM\Base\Middleware\CheckForMaintenanceMode');
		}catch(\BadMethodCallException $e){
			$this->app['router']->middleware('isAdmin', 'JSM\Base\Middleware\isAdmin');
			$this->app['router']->middleware('checkGate', 'JSM\Base\Middleware\checkGate');
			$this->app['router']->middleware('browser_language', \JSM\Base\Middleware\BrowserLanguage::class);
			// $this->app['router']->middleware('CheckForMaintenance', 'JSM\Base\Middleware\CheckForMaintenanceMode');
		}catch(\Exception $e){
			die("jsmServiceProvider: middleware method not found!");
		}
	}

}
