<?php

namespace JSM\Base\Traits;

use Illuminate\Database\Eloquent\Builder;

trait HasCompositePrimaryKey{

	/**
	 * Get the value indicating whether the IDs are incrementing.
	 *
	 * @return bool
	 */
	public function getIncrementing(){
		return false;
	}

	/**
	 * Set the keys for a save update query.
	 *
	 * @param  \Illuminate\Database\Eloquent\Builder $query
	 * @return \Illuminate\Database\Eloquent\Builder
	 */
	protected function setKeysForSaveQuery(Builder $query){
		foreach($this->getKeyName() as $key){
			if(isset($this->$key)){
				$query->where($key, '=', $this->$key);
			}else{
				throw new \Exception(__METHOD__.'Missing part of the primary key: '.$key);
			}
		}
		return $query;
	}

	/**
	 * Execute a query for a single record by ID.
	 *
	 * @param  array  $ids Array of keys, like [column => value].
	 * @param  array  $columns
	 * @return mixed|static
	 */
	public static function find($ids, $columns = ['*']){
		$me = new self;
		$query = $me->newQuery();
		foreach($me->getKeyName() as $key){
			$query->where($key, '=', $ids[$key]);
		}
		return $query->first($columns);
	}
	
	
	public function getAttribute($key)
    {
        if (! $key || is_array($key)) {
            return;
        }

        if (array_key_exists($key, $this->attributes) || $this->hasGetMutator($key)) {
            return $this->getAttributeValue($key);
        }

        if (method_exists(self::class, $key)) {
            return;
        }

        return $this->getRelationValue($key);
    }

}
